/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.license.business;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.license.business.LicenseService;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import java.io.IOException;
import java.net.URL;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class LicenseZookeeperService
implements ServerEventHandler {
    private static final String ZOOKEEPER_LICENSE_PATH = "/just/license";
    private static final Logger LOG = LoggerFactory.getLogger(LicenseZookeeperService.class);
    private final LicenseService _licenseService;
    private final CuratorFramework _curatorFramework;
    private final ClusterConfiguration _clusterConfiguration;

    @Autowired
    public LicenseZookeeperService(LicenseService licenseService, CuratorFramework curatorFramework, ClusterConfiguration clusterConfiguration) {
        this._licenseService = licenseService;
        this._curatorFramework = curatorFramework;
        this._clusterConfiguration = clusterConfiguration;
    }

    @PostConstruct
    public void copyLicenseToZookeeper() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        URL url = this._licenseService.getLicenceFileURL();
        if (url == null) {
            LOG.info("No license file URL found.");
            return;
        }
        try {
            byte[] licenseData = IOUtils.toByteArray((URL)url);
            this.persistLicenseToZookeeper(licenseData);
            LOG.info("Successfully uploaded license to Zookeeper");
        }
        catch (IOException e) {
            LOG.error("Error loading license", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error uploading license to Zookeeper", (Throwable)e);
        }
    }

    private void persistLicenseToZookeeper(byte[] licenseData) throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)this._curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ZOOKEEPER_LICENSE_PATH, licenseData);
        }
        catch (KeeperException.NodeExistsException e) {
            this._curatorFramework.setData().forPath(ZOOKEEPER_LICENSE_PATH, licenseData);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onLicenseFileChanged(FileWatchService.FileChangeEvent event) {
        if (FileWatchService.FileChangeEvent.LICENSE_FILE_CHANGED.equals(event)) {
            this.copyLicenseToZookeeper();
        }
    }
}

