/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.integration.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.integration.business.PersonExternalIdReadWriteDataService;
import de.justsoftware.onx.integration.business.PersonExternalIdService;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.integration.shared.model.ExternalSystemId;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class PersonExternalIdServiceImpl
implements PersonExternalIdService {
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private PersonExternalIdReadWriteDataService _externalIdReadWriteDataService;

    @Override
    public ExternalPersonId getExternalPersonId(PersonId personId, ExternalSystemId systemId) {
        return this._externalIdReadWriteDataService.getExternalPersonId(personId, systemId);
    }

    @Override
    public Map<PersonId, ExternalPersonId> getExternalPersonIds(List<PersonId> personIds, ExternalSystemId systemId) {
        return this._externalIdReadWriteDataService.getExternalPersonIds(personIds, systemId);
    }

    @Override
    public PersonId getPersonId(ExternalPersonId externalPersonId, ExternalSystemId systemId) {
        return this._externalIdReadWriteDataService.getPersonId(externalPersonId, systemId);
    }

    @Override
    public void setExternalPersonId(final PersonId personId, final ExternalPersonId externalPersonId, final ExternalSystemId externalSystemId, final boolean overwriteExisting) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (overwriteExisting) {
                    PersonExternalIdServiceImpl.this._externalIdReadWriteDataService.removeExternalIdentification(personId, externalSystemId);
                }
                PersonExternalIdServiceImpl.this._externalIdReadWriteDataService.insertExternalIdentification(personId, externalPersonId, externalSystemId);
            }
        });
    }

    @Override
    public void removeExternalPersonId(PersonId personId, ExternalSystemId externalSystemId) {
        this._externalIdReadWriteDataService.removeExternalIdentification(personId, externalSystemId);
    }
}

