/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.integration.business;

import com.google.common.collect.Maps;
import de.justsoftware.onx.integration.business.ExternalSystemAuthenticator;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class ExternalSystemAuthenticatorImpl
extends Authenticator
implements ExternalSystemAuthenticator {
    private final ConcurrentMap<String, PasswordAuthentication> _credentials = Maps.newConcurrentMap();

    public ExternalSystemAuthenticatorImpl() {
        Authenticator.setDefault(this);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String key = ExternalSystemAuthenticatorImpl.getKeyForUrl(this.getRequestingURL());
        return (PasswordAuthentication)this._credentials.get(key);
    }

    @Override
    public void addExternalSystemCredentials(URL baseUrl, String username, String password) {
        String key = ExternalSystemAuthenticatorImpl.getKeyForUrl(baseUrl);
        this._credentials.put(key, new PasswordAuthentication(username, password.toCharArray()));
    }

    @Nonnull
    private static final String getKeyForUrl(@Nonnull URL baseUrl) {
        return baseUrl.getProtocol() + baseUrl.getPort() + baseUrl.getHost() + baseUrl.getPath();
    }
}

