/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.business.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.DynamicAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.hierarchy.business.HierarchyModuleHandler;
import de.justsoftware.onx.hierarchy.business.HierarchyService;
import de.justsoftware.onx.hierarchy.shared.model.HierarchyModuleData;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HierarchyModuleHandlerImpl
implements HierarchyModuleHandler {
    private final HierarchyService _hierarchyService;
    private final ConfigFileService _configFileService;
    private final EntityConfigService _entityConfigService;

    @Autowired
    @ParametersAreNonnullByDefault
    public HierarchyModuleHandlerImpl(HierarchyService hierarchyService, ConfigFileService configFileService, EntityConfigService entityConfigService) {
        this._hierarchyService = hierarchyService;
        this._configFileService = configFileService;
        this._entityConfigService = entityConfigService;
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) {
        ImmutableSet<EntityType> entityTypes = this.getEntityTypes(entity.getEntity());
        ImmutableSet<Action> createPermissions = this.getAllowedCreateActions(authorizationContext, entity, entityTypes);
        return new HierarchyModuleData(this._hierarchyService.getChildTree(entity.getId(), entityTypes, authorizationContext), createPermissions);
    }

    @Nonnull
    private ImmutableSet<Action> getAllowedCreateActions(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ImmutableSet<EntityType> entityTypes) {
        ImmutableSet<Action> allowedSelectParentActions = authorizationContext.may(entity, HierarchyModuleHandlerImpl.convert(entityTypes, Actions::entitySelectParent));
        ImmutableSet<EntityType> allowedSelectParentTypes = HierarchyModuleHandlerImpl.convert(allowedSelectParentActions, HierarchyModuleHandlerImpl::actionToEntityType);
        return authorizationContext.may(entity, HierarchyModuleHandlerImpl.convert(allowedSelectParentTypes, Actions::entityCreate));
    }

    @Nonnull
    private static <I, O> ImmutableSet<O> convert(Set<I> inputs, Function<I, O> converter) {
        return (ImmutableSet)inputs.stream().map(converter).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @CheckForNull
    private static EntityType actionToEntityType(Action action) {
        if (action instanceof DynamicAction) {
            DynamicAction dynamicAction = (DynamicAction)action;
            return EntityType.valueOf(dynamicAction.getParameter());
        }
        return null;
    }

    @Nonnull
    private ImmutableSet<EntityType> getEntityTypes(@Nonnull DBEntity entity) {
        ImmutableSet<EntityType> entityTypes = this._configFileService.getConfigFile().getConfigurationFor(Path.builder().add(entity.getType()).add(StaticComponentType.HIERARCHY).build(), OptionName.HIERARCHY_ENTITY_TYPES);
        if (!CollectionUtil.isEmpty(entityTypes)) {
            return entityTypes;
        }
        return this._entityConfigService.getOrderedEntityTypes();
    }
}

