/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.heartbeat.business;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.ehcache.EhCacheHeartbeatService;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import de.justsoftware.onx.ada.AdminInternalConnector;
import de.justsoftware.onx.chat.business.ChatServiceInternalApiConnector;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.heartbeat.business.AuthenticationInternalApiConnector;
import de.justsoftware.onx.heartbeat.integration.persistence.HeartbeatDAO;
import de.justsoftware.onx.migration.business.JustImportApiConnector;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.thumbor.business.ThumborService;
import de.justsoftware.onx.wiki.business.WikiInternalApiConnector;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.session.RedisHealthService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestClientException;

@Controller
@ParametersAreNonnullByDefault
public class HeartbeatController {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatController.class);
    private final AdminInternalConnector _adminInternalConnector;
    private final HeartbeatDAO _heartbeatDao;
    private final MemcachedClientCache _memcachedClient;
    private final EhCacheHeartbeatService _ehCacheHeartbeatService;
    private final SolrClient _readSolrServer;
    private final SolrClient _writeSolrServer;
    private final ThumborService _thumborService;
    private final Settings _settings;
    private final PeopleInternalApiConnector _peopleInternalApiConnector;
    private final PermissionRequestConnector _permissionRequestConnector;
    private final Optional<JustImportApiConnector> _justImportApiConnector;
    private final DriveInternalApiConnector _driveInternalApiConnector;
    private final WikiInternalApiConnector _wikiInternalApiConnector;
    private final StorageServerHelper _storageServerHelper;
    private final AuthenticationInternalApiConnector _authenticationApiConnector;
    private final RedisHealthService _redisHealthService;
    private final ChatServiceInternalApiConnector _chatServiceInternalApiConnector;

    @Autowired
    public HeartbeatController(AdminInternalConnector adminInternalConnector, HeartbeatDAO heartbeatDao, MemcachedClientCache memcachedClient, EhCacheHeartbeatService ehCacheHeartbeatService, @Qualifier(value="readSolrServer") SolrClient readSolrServer, @Qualifier(value="writeSolrServer") SolrClient writeSolrServer, ThumborService thumborService, Settings settings, PeopleInternalApiConnector peopleInternalApiConnector, PermissionRequestConnector permissionRequestConnector, Optional<JustImportApiConnector> justImportApiConnector, DriveInternalApiConnector driveInternalApiConnector, WikiInternalApiConnector wikiInternalApiConnector, StorageServerHelper storageServerHelper, AuthenticationInternalApiConnector authenticationApiConnector, RedisHealthService redisHealthService, ChatServiceInternalApiConnector chatServiceInternalApiConnector) {
        this._adminInternalConnector = adminInternalConnector;
        this._heartbeatDao = heartbeatDao;
        this._memcachedClient = memcachedClient;
        this._ehCacheHeartbeatService = ehCacheHeartbeatService;
        this._readSolrServer = readSolrServer;
        this._writeSolrServer = writeSolrServer;
        this._thumborService = thumborService;
        this._settings = settings;
        this._peopleInternalApiConnector = peopleInternalApiConnector;
        this._permissionRequestConnector = permissionRequestConnector;
        this._justImportApiConnector = justImportApiConnector;
        this._driveInternalApiConnector = driveInternalApiConnector;
        this._wikiInternalApiConnector = wikiInternalApiConnector;
        this._storageServerHelper = storageServerHelper;
        this._authenticationApiConnector = authenticationApiConnector;
        this._redisHealthService = redisHealthService;
        this._chatServiceInternalApiConnector = chatServiceInternalApiConnector;
    }

    @RequestMapping(value={"/rest/heartbeat"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public void getHeartBeat(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        response.addHeader("Allow", "GET, HEAD");
        if (!"GET".equals(request.getMethod()) && !"HEAD".equals(request.getMethod())) {
            response.getOutputStream().print("Method not allowed");
            response.setStatus(405);
            return;
        }
        StatusBuilder result = new StatusBuilder().addStatus("database", this.testDatabase()).addStatus("cache", this.testMemcached()).addStatus("ehcache", this.testEhcache()).addStatus("solr", this.testSolr()).addStatus("storage", this.testStorage()).addStatus("thumbor", this.testThumbor()).addStatus("redis", this.testRedis());
        result.addStatus("admin", this.testAdminApp());
        result.addStatus("people", this.testPeople()).addStatus("permission", this.testPermission()).addStatus("drive", this.testDrive()).addStatus("wiki", this.testWiki());
        if (this._settings.isImportUserGroupsEnabled()) {
            result.addStatus("just-import", this.testJustImport());
        }
        if (this._settings.isAdfsEnabled()) {
            result.addStatus("authentication", this.testAuthentication());
        }
        if (this._settings.isChatOpticonEnabled()) {
            result.addStatus("chat", this.testChat());
        }
        response.getOutputStream().print(result._resultBuilder.toString());
        response.setStatus(result._ok ? 200 : 500);
    }

    @Nonnull
    private Status testStorage() {
        try {
            this._storageServerHelper.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("error checking storage", e);
        }
    }

    @Nonnull
    private Status testAdminApp() {
        try {
            this._adminInternalConnector.getHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-admin failed", e);
        }
    }

    @Nonnull
    private Status testEhcache() {
        try {
            return this._ehCacheHeartbeatService.isAlive() ? Status.OK : Status.ERROR;
        }
        catch (RuntimeException e) {
            return this.handleException("error checking ehcache", e);
        }
    }

    @Nonnull
    private Status testDatabase() {
        try {
            this._heartbeatDao.selectNow();
            return Status.OK;
        }
        catch (SQLException e) {
            return this.handleException("Heartbeat DAO request failed on SQL level", e);
        }
        catch (DAOException e) {
            return this.handleException("Heartbeat DAO request failed on DAO level", e);
        }
    }

    @Nonnull
    private Status testMemcached() {
        try {
            this._memcachedClient.testCache();
            return Status.OK;
        }
        catch (InterruptedException e) {
            return this.handleException("Heartbeat cache request failed due to thread interruption", e);
        }
        catch (ExecutionException e) {
            return this.handleException("Heartbeat cache request failed due to execution", e);
        }
        catch (TimeoutException e) {
            return this.handleException("Heartbeat cache request failed due to timeout", e);
        }
    }

    @Nonnull
    private Status testSolr() {
        try {
            this._readSolrServer.ping();
            this._writeSolrServer.ping();
            return Status.OK;
        }
        catch (IOException | SolrServerException e) {
            return this.handleException("Heartbeat Solr request failed", (Exception)e);
        }
    }

    @Nonnull
    private Status testThumbor() {
        try {
            this._thumborService.checkHealth();
            return Status.OK;
        }
        catch (ServiceException | RestClientException e) {
            return this.handleException("Heartbeat Thumbor request failed", (Exception)e);
        }
    }

    @Nonnull
    private Status handleException(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        return Status.ERROR;
    }

    @Nonnull
    private Status testPeople() {
        return this._peopleInternalApiConnector.available() ? Status.OK : Status.ERROR;
    }

    @Nonnull
    private Status testPermission() {
        return this._permissionRequestConnector.heartbeat() ? Status.OK : Status.ERROR;
    }

    @Nonnull
    private Status testWiki() {
        try {
            this._wikiInternalApiConnector.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-wiki failed", e);
        }
    }

    @Nonnull
    private Status testDrive() {
        try {
            this._driveInternalApiConnector.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-drive failed", e);
        }
    }

    @Nonnull
    private Status testAuthentication() {
        try {
            this._authenticationApiConnector.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-authentication failed", e);
        }
    }

    @Nonnull
    private Status testJustImport() {
        try {
            this._justImportApiConnector.orElseThrow(() -> new ServiceException("Import api connector not configured")).checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-import failed", e);
        }
    }

    @Nonnull
    private Status testRedis() {
        try {
            this._redisHealthService.checkHealth();
            return Status.OK;
        }
        catch (RedisHealthService.RedisHealthException | DataAccessException e) {
            return this.handleException("Health check for Redis failed", (Exception)e);
        }
    }

    @Nonnull
    private Status testChat() {
        try {
            this._chatServiceInternalApiConnector.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for Chat failed", e);
        }
    }

    @ParametersAreNonnullByDefault
    private static class StatusBuilder {
        private final StringBuilder _resultBuilder = new StringBuilder();
        private boolean _ok = true;

        private StatusBuilder() {
        }

        @Nonnull
        StatusBuilder addStatus(String service, Status status) {
            this._resultBuilder.append(service).append(":").append(status.name()).append("\n");
            switch (status) {
                case OK: {
                    break;
                }
                case ERROR: {
                    this._ok = false;
                }
            }
            return this;
        }
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

