/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.heartbeat.business;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.common.shared.model.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

@Service
public class AuthenticationInternalApiConnector {
    private final String _monitoringApiUrl;
    private final RestOperations _restTemplate;

    @Autowired
    public AuthenticationInternalApiConnector(@Value(value="${just-authentication.monitoring.url:http://localhost:8002/authentication/manage}") String monitoringApiUrl, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._monitoringApiUrl = monitoringApiUrl;
        this._restTemplate = restTemplate;
    }

    public void checkHealth() {
        try {
            this._restTemplate.getForEntity(this._monitoringApiUrl + "/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("Authorization health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString() + ")");
        }
    }
}

