/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.model;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.export.ldap.model.InvalidMemberRoleUpdateKafkaKeyException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MemberRoleUpdateKafkaKey {
    final PersonId _personId;
    final EntityId _entityId;
    final EntityMemberRole _entityMemberRole;

    public MemberRoleUpdateKafkaKey(PersonId personId, EntityId entityId, EntityMemberRole entityMemberRole) {
        this._personId = personId;
        this._entityId = entityId;
        this._entityMemberRole = entityMemberRole;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public EntityMemberRole getEntityMemberRole() {
        return this._entityMemberRole;
    }

    public String toString() {
        return this._personId.getId() + "@" + this._entityMemberRole.getName() + "," + this._entityId.getId();
    }

    @Nonnull
    public static MemberRoleUpdateKafkaKey parse(String string) {
        String[] keyParts = string.split("@");
        if (keyParts.length != 2) {
            throw new InvalidMemberRoleUpdateKafkaKeyException(string);
        }
        PersonId personId = PersonId.parse(keyParts[0]);
        if (personId == null) {
            throw new InvalidMemberRoleUpdateKafkaKeyException(string);
        }
        String[] entityParts = keyParts[1].split(",");
        if (entityParts.length != 2) {
            throw new InvalidMemberRoleUpdateKafkaKeyException(string);
        }
        EntityMemberRole entityMemberRole = EntityMemberRole.valueOf(entityParts[0]);
        EntityId entityId = EntityId.parse(entityParts[1]);
        if (entityId == null) {
            throw new InvalidMemberRoleUpdateKafkaKeyException(string);
        }
        return new MemberRoleUpdateKafkaKey(personId, entityId, entityMemberRole);
    }
}

