/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.configuration;

import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityReadDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.export.ldap.business.LDAPMemberGroupExporter;
import de.justsoftware.onx.export.ldap.business.MemberGroupExportEventProcessor;
import de.justsoftware.onx.export.ldap.business.MemberGroupExportService;
import de.justsoftware.onx.export.ldap.business.MemberGroupExportUpdateConsumer;
import de.justsoftware.onx.export.ldap.business.MemberGroupExportUpdateProducer;
import de.justsoftware.onx.export.ldap.business.MemberRoleExportEventProcessor;
import de.justsoftware.onx.export.ldap.business.MemberRoleExportUpdateConsumer;
import de.justsoftware.onx.export.ldap.business.MemberRoleExportUpdateProducer;
import de.justsoftware.onx.export.ldap.configuration.ShouldProvideBeansForLDAPExport;
import de.justsoftware.onx.export.ldap.metrics.business.LDAPMemberGroupMetricsService;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class LDAPExportConfiguration {
    private final TransactionHelper _transactionHelper;
    private final KafkaConfigurationProvider _kafkaConfigurationProvider;
    private final EntityService _entityService;
    private final EntityVersionService _entityVersionService;
    private final EntityReadDataService _entityReadDataService;
    private final EntityMemberService _entityMemberService;

    @Autowired
    public LDAPExportConfiguration(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, EntityService entityService, EntityVersionService entityVersionService, EntityReadDataService entityReadDataService, EntityMemberService entityMemberService) {
        this._transactionHelper = transactionHelper;
        this._kafkaConfigurationProvider = kafkaConfigurationProvider;
        this._entityService = entityService;
        this._entityVersionService = entityVersionService;
        this._entityReadDataService = entityReadDataService;
        this._entityMemberService = entityMemberService;
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberGroupExportUpdateConsumer memberGroupExportUpdateConsumer(@Qualifier(value="ldapExports") List<LDAPMemberGroupExporter> ldapMemberGroupExporters) {
        return new MemberGroupExportUpdateConsumer(this._transactionHelper, this._kafkaConfigurationProvider, this._entityService, this._entityVersionService, ldapMemberGroupExporters);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberGroupExportUpdateProducer memberGroupExportUpdateProducer(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        return new MemberGroupExportUpdateProducer(producer);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberRoleExportUpdateConsumer memberRoleExportUpdateConsumer(@Qualifier(value="ldapExports") List<LDAPMemberGroupExporter> ldapMemberGroupExporters) {
        return new MemberRoleExportUpdateConsumer(this._transactionHelper, this._kafkaConfigurationProvider, this._entityService, this._entityVersionService, ldapMemberGroupExporters);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberRoleExportUpdateProducer memberRoleExportUpdateProducer(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        return new MemberRoleExportUpdateProducer(producer);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberGroupExportEventProcessor memberGroupExportEventProcessor(MemberGroupExportUpdateProducer memberGroupExportUpdateProducer) {
        return new MemberGroupExportEventProcessor(memberGroupExportUpdateProducer);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberRoleExportEventProcessor memberRoleExportEventProcessor(MemberRoleExportUpdateProducer memberRoleExportUpdateProducer) {
        return new MemberRoleExportEventProcessor(memberRoleExportUpdateProducer);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public MemberGroupExportService memberGroupExportService(@Qualifier(value="ldapExports") List<LDAPMemberGroupExporter> ldapMemberGroupExporters, MemberRoleExportUpdateConsumer memberRoleExportUpdateConsumer, MemberGroupExportUpdateConsumer memberGroupExportUpdateConsumer) {
        return new MemberGroupExportService(this._entityService, this._entityReadDataService, this._entityMemberService, memberRoleExportUpdateConsumer, memberGroupExportUpdateConsumer, ldapMemberGroupExporters);
    }

    @Bean
    @Conditional(value={ShouldProvideBeansForLDAPExport.class})
    @Nonnull
    public LDAPMemberGroupMetricsService ldapMemberGroupMetricsService(MemberGroupExportUpdateConsumer memberGroupExportUpdateConsumer, MemberRoleExportUpdateConsumer memberRoleExportUpdateConsumer) {
        return new LDAPMemberGroupMetricsService(memberGroupExportUpdateConsumer, memberRoleExportUpdateConsumer);
    }
}

