/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.impl.DistinguishedNameContextMapper;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContextIterator;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class PersonIdToDistinguishedNameResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PersonIdToDistinguishedNameResolver.class);
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final InternalLDAPSearchContext _personSearchContext;
    private final Map<PersonId, String> _resolvedMappings = Maps.newHashMap();
    private final DomainResolver _domainResolver;

    public PersonIdToDistinguishedNameResolver(@Nonnull InternalLDAPSearchContext personSearchContext, @Nonnull PersonImportMappingDAO personImportMappingDAO, @Nonnull DomainResolver domainResolver) {
        this._personSearchContext = personSearchContext;
        this._personImportMappingDAO = personImportMappingDAO;
        this._domainResolver = domainResolver;
    }

    @CheckForNull
    public String resolveToPersonDn(@Nonnull PersonId personId) {
        String knownName = this._resolvedMappings.get(personId);
        if (knownName != null) {
            return knownName;
        }
        String externalPersonId = this._personImportMappingDAO.getExternalId(personId);
        if (externalPersonId == null) {
            return null;
        }
        LDAPPersonIdentifier identifier = LDAPPersonIdentifier.parse(this._personSearchContext.getExternalIdField().getFieldName(), externalPersonId, this._domainResolver);
        if (identifier == null) {
            return null;
        }
        Name dn = this.searchLDAPByExternalId(identifier.getUsername());
        if (dn != null) {
            this._resolvedMappings.put(personId, dn.toString());
            return dn.toString();
        }
        return null;
    }

    @CheckForNull
    private Name searchLDAPByExternalId(@Nonnull String externalPersonId) {
        InternalLDAPSearchContext searchContextWithFilter = this._personSearchContext.withFilter(this.createUserFilter(this._personSearchContext.getFilter(), externalPersonId));
        try {
            LOG.info("({}) Searching person by external id: {}", (Object)this.getClass().getSimpleName(), (Object)externalPersonId);
            Iterator<List<Name>> iterator = LDAPSearchContextIterator.getImportModelsFromContext(searchContextWithFilter, new DistinguishedNameContextMapper());
            List names = (List)Iterators.getNext(iterator, List.of());
            Name name = (Name)Iterables.getFirst((Iterable)Objects.requireNonNull(names), null);
            while (iterator.hasNext()) {
                iterator.next();
            }
            return name;
        }
        catch (ImportException e) {
            LOG.error("Error occurred while searching ldap person by external id " + externalPersonId, (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private Filter createUserFilter(@Nullable Filter configuredFilter, @Nonnull String externalPersonId) {
        String filterField = this._personSearchContext.getExternalIdField().getFieldName();
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(filterField, externalPersonId));
        if (configuredFilter != null) {
            andFilter.and(configuredFilter);
        }
        return andFilter;
    }
}

