/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.events.EntityMemberRolesChangedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.export.ldap.business.MemberRoleExportUpdateProducer;
import de.justsoftware.onx.export.ldap.model.MemberRoleUpdateAction;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MemberRoleExportEventProcessor
implements ServerEventHandler {
    final MemberRoleExportUpdateProducer _producer;

    public MemberRoleExportEventProcessor(MemberRoleExportUpdateProducer producer) {
        this._producer = producer;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMemberRolesChanged(EntityMemberRolesChangedEvent e) {
        EntityId entityId = e.getEntityId();
        PersonId personId = e.getPersonId();
        ImmutableSet<EntityMemberRole> newRoles = e.getNewRoles();
        ImmutableSet<EntityMemberRole> oldRoles = e.getOldRoles();
        this.publishDifferences(personId, entityId, newRoles, oldRoles);
    }

    private void publishDifferences(PersonId personId, EntityId entityId, ImmutableSet<EntityMemberRole> newMemberRoles, ImmutableSet<EntityMemberRole> oldMemberRoles) {
        Sets.SetView addedRoles = Sets.difference(newMemberRoles, oldMemberRoles);
        Sets.SetView removedRoles = Sets.difference(oldMemberRoles, newMemberRoles);
        addedRoles.forEach(role -> this._producer.publish(personId, entityId, (EntityMemberRole)role, MemberRoleUpdateAction.ADD));
        removedRoles.forEach(role -> this._producer.publish(personId, entityId, (EntityMemberRole)role, MemberRoleUpdateAction.REMOVE));
    }
}

