/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.export.ldap.business.LDAPMemberGroupExporter;
import de.justsoftware.onx.export.ldap.model.MemberGroupExportException;
import de.justsoftware.onx.export.ldap.model.MemberGroupUpdateAction;
import de.justsoftware.onx.export.ldap.model.MemberGroupUpdateKafkaKey;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MemberGroupExportUpdateConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.export.memberGroupUpdates";
    private static final Logger LOG = LoggerFactory.getLogger(MemberGroupExportUpdateConsumer.class);
    private final EntityService _entityService;
    private final EntityVersionService _entityVersionService;
    private final ImmutableList<LDAPMemberGroupExporter> _memberGroupExporters;

    public MemberGroupExportUpdateConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, EntityService entityService, EntityVersionService entityVersionService, List<LDAPMemberGroupExporter> memberGroupExporters) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.MemberGroupExportUpdateConsumer"), transactionHelper, entityService, entityVersionService, memberGroupExporters);
    }

    @VisibleForTesting
    MemberGroupExportUpdateConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, EntityService entityService, EntityVersionService entityVersionService, List<LDAPMemberGroupExporter> memberGroupExporters) {
        super(consumer, transactionHelper, TOPIC);
        this._entityService = entityService;
        this._entityVersionService = entityVersionService;
        this._memberGroupExporters = ImmutableList.copyOf(memberGroupExporters);
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) throws MemberGroupExportException {
        records.forEach(record -> {
            boolean ignoreUpdateEvent;
            MemberGroupUpdateKafkaKey key = MemberGroupUpdateKafkaKey.parse((String)record.key());
            EntityId entityId = key.getEntityId();
            MemberGroupUpdateAction memberGroupUpdateAction = MemberGroupUpdateAction.valueOf((String)record.value());
            DBEntity entity = this._entityService.getById(entityId);
            EntityVersion newestVersion = this._entityVersionService.getNewestVersionWithStatus(entityId, (Set<EntityStatus>)ImmutableSet.of());
            if (entity == null || newestVersion == null) {
                LOG.warn("Could not export non existent entity " + entityId);
                return;
            }
            boolean bl = ignoreUpdateEvent = newestVersion.getStatus().isArchived() && memberGroupUpdateAction != MemberGroupUpdateAction.ARCHIVE;
            if (ignoreUpdateEvent) {
                return;
            }
            try {
                this._memberGroupExporters.forEach(exporter -> exporter.processEntityUpdate(entity, memberGroupUpdateAction));
            }
            catch (MemberGroupExportException e) {
                LOG.error("Processing record with offset " + record.offset() + " failed. Could not process entity update " + memberGroupUpdateAction + " " + key, (Throwable)e);
                throw e;
            }
        });
    }
}

