/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.export.ldap.business.PersonIdToDistinguishedNameResolver;
import de.justsoftware.onx.export.ldap.model.MemberGroupExportException;
import de.justsoftware.onx.export.ldap.model.MemberGroupUpdateAction;
import de.justsoftware.onx.export.ldap.model.MemberRoleUpdateAction;
import de.justsoftware.onx.export.ldap.util.LDAPUtil;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;

@ParametersAreNonnullByDefault
public class LDAPMemberGroupExporter
implements InitializingBean {
    public static final String DEFAULT_NO_MEMBER_DN = "cn=no-member";
    private final EntityImportDAO<String> _entityImportDAO;
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final DomainResolver _domainResolver;
    private Logger _log;
    private String _memberAttribute = "member";
    private String _noMemberDN = "cn=no-member";
    private String _objectClass = "groupOfNames";
    private boolean _deleteGroupIfArchived = false;
    private boolean _exportExternalId = false;
    private boolean _updateGroup = true;
    private LdapTemplate _ldapTemplate;
    private String _baseDN;
    private InternalLDAPSearchContext _personSearchContext;
    private PersonIdToDistinguishedNameResolver _personIdToDnResolver;
    private String _memberGroupCnSuffix;
    private String _titleAttribute;
    private String _externalIdAttribute;
    private EntityType _handledEntityType;
    private EntityMemberRole _handledMemberRole;

    @Autowired
    public LDAPMemberGroupExporter(PersonImportMappingDAO personImportMappingDAO, DomainResolver domainResolver, EntityImportDAO<String> entityImportDAO) {
        this._personImportMappingDAO = personImportMappingDAO;
        this._domainResolver = domainResolver;
        this._entityImportDAO = entityImportDAO;
    }

    @VisibleForTesting
    public LDAPMemberGroupExporter(PersonImportMappingDAO personImportMappingDAO, DomainResolver domainResolver, EntityImportDAO<String> entityImportDAO, PersonIdToDistinguishedNameResolver personIdToDnResolver) {
        this(personImportMappingDAO, domainResolver, entityImportDAO);
        this._personIdToDnResolver = personIdToDnResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this._handledEntityType == null) {
            throw new IllegalStateException("HandledEntityType must be set.");
        }
        if (this._memberGroupCnSuffix == null) {
            throw new IllegalStateException("MemberGroupCnSuffix must be set.");
        }
        if (this._ldapTemplate == null) {
            throw new IllegalStateException("LdapTemplate must be set.");
        }
        if (this._baseDN == null) {
            throw new IllegalStateException("BaseDN must be set.");
        }
        if (this._personSearchContext == null) {
            throw new IllegalStateException("PersonSearchContext must be set.");
        }
        if (this._exportExternalId && Strings.isNullOrEmpty((String)this._externalIdAttribute)) {
            throw new IllegalStateException("Can not export external id without setting externalIdAttribute.");
        }
        if (this._personIdToDnResolver == null) {
            this._personIdToDnResolver = new PersonIdToDistinguishedNameResolver(this._personSearchContext, this._personImportMappingDAO, this._domainResolver);
        }
        this._log = LoggerFactory.getLogger((String)(LDAPMemberGroupExporter.class + "(" + this._handledEntityType + "|" + this._handledMemberRole + ")"));
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this._ldapTemplate = ldapTemplate;
    }

    public void setBaseDN(String baseDN) {
        this._baseDN = baseDN;
    }

    public void setHandledEntityType(String handledEntityType) {
        this._handledEntityType = EntityType.valueOf(handledEntityType);
    }

    public void setPersonSearchContext(LDAPSearchContext personSearchContext) {
        this._personSearchContext = InternalLDAPSearchContext.createFrom(personSearchContext);
    }

    public void setExportExternalId(boolean exportExternalId) {
        this._exportExternalId = exportExternalId;
    }

    public void setExternalIdAttribute(String externalIdAttribute) {
        this._externalIdAttribute = externalIdAttribute;
    }

    public void setTitleAttribute(String titleAttribute) {
        this._titleAttribute = titleAttribute;
    }

    public void setMemberAttribute(String memberAttribute) {
        this._memberAttribute = memberAttribute;
    }

    public void setNoMemberDN(String noMemberDN) {
        this._noMemberDN = noMemberDN;
    }

    public void setObjectClass(String objectClass) {
        this._objectClass = objectClass;
    }

    public void setUpdateGroup(boolean updateGroup) {
        this._updateGroup = updateGroup;
    }

    public void setMemberGroupCNSuffix(String memberGroupCnSuffix) {
        this._memberGroupCnSuffix = memberGroupCnSuffix;
    }

    public void setDeleteGroupIfArchived(boolean deleteGroupIfArchived) {
        this._deleteGroupIfArchived = deleteGroupIfArchived;
    }

    public void setHandledMemberRole(EntityMemberRole handledMemberRole) {
        this._handledMemberRole = handledMemberRole;
    }

    public void processMemberUpdate(DBEntity entity, PersonId personId, EntityMemberRole memberRole, MemberRoleUpdateAction memberRoleUpdateAction) throws MemberGroupExportException {
        if (!this.handlesType(entity.getType())) {
            return;
        }
        EntityId entityId = entity.getId();
        this._log.info("Process member update for entity " + entityId);
        Attributes additionalAttributes = this.getAdditionalAttributes(entity);
        LDAPMemberGroup memberGroup = new LDAPMemberGroup(entityId, this._memberGroupCnSuffix, additionalAttributes);
        if (memberRole == this._handledMemberRole) {
            memberGroup.updateMembers(personId, memberRoleUpdateAction);
        }
        memberGroup.persist();
    }

    public void processEntityUpdate(DBEntity entity, MemberGroupUpdateAction memberGroupUpdateAction) throws MemberGroupExportException {
        if (!this.handlesType(entity.getType())) {
            return;
        }
        EntityId entityId = entity.getId();
        this._log.info("Process entity update for entity " + entityId);
        if (memberGroupUpdateAction == MemberGroupUpdateAction.ARCHIVE) {
            if (this._deleteGroupIfArchived) {
                this.deleteLDAPMemberGroup(entityId, this._memberGroupCnSuffix);
            }
            return;
        }
        Attributes additionalAttributes = this.getAdditionalAttributes(entity);
        LDAPMemberGroup memberGroup = new LDAPMemberGroup(entityId, this._memberGroupCnSuffix, additionalAttributes);
        memberGroup.persist();
    }

    public void fullMemberGroupExport(EntityType entityType, ImmutableListMultimap<DBEntity, EntityMemberWithPerson> members) {
        if (!this.handlesType(entityType)) {
            return;
        }
        this._log.info("Starting full member group export with " + members.size() + " total members.");
        ImmutableSetMultimap membersByEntities = (ImmutableSetMultimap)members.entries().stream().filter(e -> this.handlesType(((DBEntity)e.getKey()).getType())).filter(e -> ((EntityMemberWithPerson)e.getValue()).getRoles().contains((Object)this._handledMemberRole)).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, e -> ((EntityMemberWithPerson)e.getValue()).getPersonId()));
        membersByEntities.keySet().forEach(entity -> {
            Attributes additionalAttributes = this.getAdditionalAttributes((DBEntity)entity);
            LDAPMemberGroup memberGroup = new LDAPMemberGroup(entity.getId(), this._memberGroupCnSuffix, additionalAttributes);
            memberGroup.setMembers((ImmutableSet<PersonId>)membersByEntities.get(entity));
            try {
                memberGroup.persist();
            }
            catch (MemberGroupExportException e) {
                this._log.error("Could not export member group " + entity.getId() + this._memberGroupCnSuffix + ".", (Throwable)e);
            }
        });
    }

    @Nonnull
    public EntityType getHandledEntityType() {
        return this._handledEntityType;
    }

    private boolean handlesType(EntityType entityType) {
        return this._handledEntityType == entityType;
    }

    @Nonnull
    private String toCN(EntityId id, String suffix) {
        return id.getId() + suffix;
    }

    @Nonnull
    private String toDN(String cn) {
        return Joiner.on((String)",").skipNulls().join((Object)("cn=" + cn), (Object)this._baseDN, new Object[0]);
    }

    @Nonnull
    private Attributes getAdditionalAttributes(DBEntity entity) {
        String externalId;
        BasicAttributes attributes = new BasicAttributes();
        if (this._exportExternalId && (externalId = this._entityImportDAO.getExternalId(entity.getId())) != null) {
            attributes.put(this._externalIdAttribute, externalId);
        }
        if (!StringUtil.isBlank(this._titleAttribute)) {
            attributes.put(this._titleAttribute, entity.getName());
        }
        return attributes;
    }

    private void deleteLDAPMemberGroup(EntityId entityId, String memberGroupCnSuffix) {
        String cn = this.toCN(entityId, memberGroupCnSuffix);
        String dn = this.toDN(cn);
        LDAPUtil.deleteContext(this._ldapTemplate, dn);
        this._log.info("Deleted member group " + dn);
    }

    @ParametersAreNonnullByDefault
    public final class LDAPMemberGroup {
        private final DirContextAdapter _context;
        private final boolean _persisted;
        private final String _entityCn;
        private final String _entityDn;

        public LDAPMemberGroup(EntityId entityId, String memberGroupCnSuffix, Attributes additionalAttributes) {
            this._entityCn = LDAPMemberGroupExporter.this.toCN(entityId, memberGroupCnSuffix);
            this._entityDn = LDAPMemberGroupExporter.this.toDN(this._entityCn);
            DirContextAdapter context = LDAPUtil.lookupContext(LDAPMemberGroupExporter.this._ldapTemplate, this._entityDn);
            if (context == null) {
                this._context = this.createNewContext();
                this._persisted = false;
            } else {
                this._context = context;
                this._persisted = true;
            }
            if (!this._persisted || LDAPMemberGroupExporter.this._updateGroup) {
                LDAPUtil.setAttributes(this._context, additionalAttributes);
            }
        }

        @Nonnull
        public DirContextAdapter getContext() {
            return this._context;
        }

        public void persist() throws MemberGroupExportException {
            try {
                if (!this._persisted) {
                    LDAPUtil.createContext(LDAPMemberGroupExporter.this._ldapTemplate, this._entityDn, this._context);
                    LDAPMemberGroupExporter.this._log.info("Created new member group " + this._entityDn);
                } else if (LDAPMemberGroupExporter.this._updateGroup) {
                    LDAPUtil.updateContext(LDAPMemberGroupExporter.this._ldapTemplate, this._context);
                    LDAPMemberGroupExporter.this._log.info("Updated member group " + this._entityDn);
                } else {
                    LDAPMemberGroupExporter.this._log.info("Skipping update of member group with DN " + this._entityDn + " as group already exists and updateGroup was set to false.");
                }
            }
            catch (IllegalStateException | NamingException e) {
                throw new MemberGroupExportException("Could not export member group " + this._entityCn + ".", e);
            }
        }

        public void updateMembers(PersonId memberId, MemberRoleUpdateAction updateAction) {
            String personDn = LDAPMemberGroupExporter.this._personIdToDnResolver.resolveToPersonDn(memberId);
            if (personDn == null) {
                LDAPMemberGroupExporter.this._log.warn("Could not export member role change for person with id " + memberId + " because a DN for this user could not be resolved.");
                return;
            }
            if (updateAction == MemberRoleUpdateAction.ADD) {
                this.addMember(personDn);
                this.removeMember(LDAPMemberGroupExporter.this._noMemberDN);
                this.logMemberUpdate(personDn, true);
            } else {
                if (this.personIsLastMemberInGroup(personDn)) {
                    this.addMember(LDAPMemberGroupExporter.this._noMemberDN);
                    LDAPMemberGroupExporter.this._log.debug("Group will be empty after update. Adding " + LDAPMemberGroupExporter.this._noMemberDN + " to member group " + this._entityCn);
                }
                this.removeMember(personDn);
                this.logMemberUpdate(personDn, false);
            }
        }

        public void setMembers(ImmutableSet<PersonId> memberIds) {
            Object[] members = (String[])memberIds.stream().map(LDAPMemberGroupExporter.this._personIdToDnResolver::resolveToPersonDn).filter(Objects::nonNull).peek(dn -> this.logMemberUpdate((String)dn, true)).toArray(String[]::new);
            this._context.setAttributeValues(LDAPMemberGroupExporter.this._memberAttribute, members);
            LDAPMemberGroupExporter.this._log.info("Added " + members.length + " members to member group " + this._entityCn);
        }

        private void logMemberUpdate(String memberDn, boolean added) {
            LDAPMemberGroupExporter.this._log.info((String)(added ? "Added" : "Removed member " + memberDn + " from member group " + this._entityCn));
        }

        @Nonnull
        private DirContextAdapter createNewContext() {
            DirContextAdapter context = new DirContextAdapter();
            context.setAttributeValue("objectclass", (Object)LDAPMemberGroupExporter.this._objectClass);
            context.setAttributeValue("cn", (Object)this._entityCn);
            context.setAttributeValue(LDAPMemberGroupExporter.this._memberAttribute, (Object)LDAPMemberGroupExporter.this._noMemberDN);
            return context;
        }

        private boolean personIsLastMemberInGroup(String personDn) {
            String[] memberAttributeValues = this._context.getStringAttributes(LDAPMemberGroupExporter.this._memberAttribute);
            return memberAttributeValues != null && memberAttributeValues.length == 1 && memberAttributeValues[0].equals(personDn);
        }

        private void addMember(String memberDn) {
            if (!this.hasMember(memberDn)) {
                this._context.addAttributeValue(LDAPMemberGroupExporter.this._memberAttribute, (Object)memberDn);
            }
        }

        private boolean hasMember(String memberDn) {
            String[] memberAttributeValues = this._context.getStringAttributes(LDAPMemberGroupExporter.this._memberAttribute);
            return memberAttributeValues != null && Arrays.asList(memberAttributeValues).contains(memberDn);
        }

        private void removeMember(String memberDn) {
            this._context.removeAttributeValue(LDAPMemberGroupExporter.this._memberAttribute, (Object)memberDn);
        }
    }
}

