/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.events.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.BatchStatementProcessor;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.events.integration.persistence.EventQueueDAO;
import de.justsoftware.onx.events.shared.server.model.DBUpdateEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractIbatisUpdateEventQueueDAO
implements EventQueueDAO {
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;

    @Nonnull
    protected abstract String getNameSpace();

    @Override
    public void creates(List<DBUpdateEvent> events) {
        IbatisDAOUtil.executeInBatch(this._sqlMapper, events, 1000, new BatchStatementProcessor<DBUpdateEvent>(){

            @Override
            public void process(SqlMapClient client, DBUpdateEvent event) throws SQLException {
                client.insert(AbstractIbatisUpdateEventQueueDAO.this.getNameSpace() + "insertEntry", (Object)event);
            }
        });
    }

    @Override
    public List<DBUpdateEvent> getEvents(int maxResults) {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, this.getNameSpace() + "getEntries", null, 0, maxResults);
    }

    @Override
    public void delete(List<DBUpdateEvent> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ImmutableSet ids = FluentIterable.from(entries).transform(DBUpdateEvent::getId).toSet();
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, this.getNameSpace() + "deleteEntries", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public int deleteEntriesOlderThan(Set<DBUpdateEvent> entries, DateTime olderThan) {
        if (Iterables.isEmpty(entries)) {
            return 0;
        }
        return IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, this.getNameSpace() + "deleteEntriesOlderThan", entries, IbatisDAOUtil.createParameterFunctionForIdsWithMapData("entries", ImmutableMap.of((Object)"olderThan", (Object)olderThan.toDate())));
    }

    @Override
    public long getQueueSize() {
        Long size = (Long)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, this.getNameSpace() + "getQueueSize");
        return size;
    }
}

