/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.events.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.comments.business.events.CommentUpdatedEvent;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.events.CommentDeletedEvent;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityComponentPositionsChangedEvent;
import de.justsoftware.onx.container.business.events.EntityDescriptionUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityMemberRolesChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.business.events.EntityNameUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionArchivedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionStatusUpdateEvent;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.business.events.WorkstreamModuleDeletedEvent;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.events.ChatMessageUpdateEvent;
import de.justsoftware.onx.events.CommentParentUpdateEvent;
import de.justsoftware.onx.events.ContactUpdateEvent;
import de.justsoftware.onx.events.ConversationDeleteEvent;
import de.justsoftware.onx.events.ConversationUpdateEvent;
import de.justsoftware.onx.events.EntityAdminUpdateEvent;
import de.justsoftware.onx.events.EntityMemberUpdateEvent;
import de.justsoftware.onx.events.EntityNameUpdateEvent;
import de.justsoftware.onx.events.EntityParentUpdateEvent;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.EntityUpdateModifyDateEvent;
import de.justsoftware.onx.events.EntityVersionArchivedUpdateEvent;
import de.justsoftware.onx.events.EntityVersionPublishedUpdateEvent;
import de.justsoftware.onx.events.EntityVersionStatusUpdatedEvent;
import de.justsoftware.onx.events.EntityVisibilitiesUpdateEvent;
import de.justsoftware.onx.events.MicroblogUpdateEvent;
import de.justsoftware.onx.events.PersonActivatedEvent;
import de.justsoftware.onx.events.PersonBlockedStatusChangedEvent;
import de.justsoftware.onx.events.PersonDeactivatedEvent;
import de.justsoftware.onx.events.PersonModifyDateUpdateEvent;
import de.justsoftware.onx.events.PersonRolesChangedEvent;
import de.justsoftware.onx.events.PersonUpdateEvent;
import de.justsoftware.onx.events.PersonUpdatedEvent;
import de.justsoftware.onx.events.ProfileVisibilitiesChangedEvent;
import de.justsoftware.onx.events.ProfileVisibilitiesUpdateEvent;
import de.justsoftware.onx.events.SubscriberUpdateEvent;
import de.justsoftware.onx.events.UpdateEvent;
import de.justsoftware.onx.events.UpdateEventVisitor;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.events.business.UpdateEventProcessor;
import de.justsoftware.onx.events.business.impl.EventQueueProcessor;
import de.justsoftware.onx.events.integration.persistence.UpdateEventQueueDAO;
import de.justsoftware.onx.events.shared.server.model.DBUpdateEvent;
import de.justsoftware.onx.events.shared.server.model.UpdateEventType;
import de.justsoftware.onx.message.business.events.ChatMessageAddedOrDeletedEvent;
import de.justsoftware.onx.message.business.events.ConversationDeletedEvent;
import de.justsoftware.onx.message.business.events.ConversationUpdatedEvent;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.multiwiki.business.events.MultiWikiVersionCreatedEvent;
import de.justsoftware.onx.person.business.events.NewContactEvent;
import de.justsoftware.onx.person.business.events.ProfileChangedEvent;
import de.justsoftware.onx.person.business.events.RemoveContactEvent;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.business.event.MicroblogAttachmentDeletedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingPublishedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingUpdatedEvent;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="searchUpdateHandlerService")
@ParametersAreNonnullByDefault
public class DatabaseQueueUpdateEventHandlerImpl
implements ServerEventHandler,
UpdateEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseQueueUpdateEventHandlerImpl.class);
    private static final int DEFAULT_FETCH_SIZE = 50;
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private Set<UpdateEventProcessor> _updateEventProcessors;
    @Autowired
    private QueueStatisticsService _queueStatisticsService;
    @Autowired
    private UpdateEventQueueDAO _updateEventQueueDAO;
    @Autowired
    private Clock _clock;
    @Autowired
    private ClusterConfiguration _clusterConfiguration;
    @Autowired
    private Settings _settings;
    private EventQueueProcessor _queueProcessor;
    private int _fetchSize = 50;

    public DatabaseQueueUpdateEventHandlerImpl() {
    }

    @VisibleForTesting
    DatabaseQueueUpdateEventHandlerImpl(WorkstreamService workstreamService, Set<UpdateEventProcessor> updateEventProcessors, QueueStatisticsService queueStatisticsService, UpdateEventQueueDAO updateEventQueueDAO, Clock clock, ClusterConfiguration clusterConfiguration, Settings settings) {
        this._workstreamService = workstreamService;
        this._updateEventProcessors = updateEventProcessors;
        this._queueStatisticsService = queueStatisticsService;
        this._updateEventQueueDAO = updateEventQueueDAO;
        this._clock = clock;
        this._clusterConfiguration = clusterConfiguration;
        this._settings = settings;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this._queueProcessor = new EventQueueProcessor(this._updateEventQueueDAO, this._clock, this._queueStatisticsService, QueueName.UPDATE_EVENT);
    }

    public void setFetchSize(int fetchSize) {
        this._fetchSize = fetchSize;
    }

    @Override
    public void onChange(UpdateEvent<?> updateEvent) {
        this.onChanges((Iterable<? extends UpdateEvent<?>>)ImmutableList.of(updateEvent));
    }

    @Override
    public void onChanges(Iterable<? extends UpdateEvent<?>> updateEvents) {
        DateTime now = this._clock.now();
        ImmutableList dbEvents = FluentIterable.from(updateEvents).filter(Predicates.notNull()).transform(input -> DBUpdateEvent.createNew(input.accept(EventToTypeVisitor.INSTANCE), input.getItemId(), now)).toList();
        this._updateEventQueueDAO.creates((List<DBUpdateEvent>)dbEvents);
    }

    @Override
    public void processEvents() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        if (this._queueProcessor != null) {
            this._queueProcessor.processEvents(this._fetchSize, (type, itemIds) -> {
                LOG.info("Processing events of type {} ...", (Object)type);
                for (UpdateEventProcessor processor : this._updateEventProcessors) {
                    try {
                        processor.processEventsOfType(type, itemIds);
                    }
                    catch (RuntimeException e) {
                        LOG.error(String.format("Error while processing events of type %s with update processor %s. Proccessing of these entries will be skipped for this processor and continued with next processor.", new Object[]{type, processor.getClass().getSimpleName()}), (Throwable)e);
                        LOG.debug("Error occurred when processing item ids {} of type {}", (Object)itemIds, (Object)type);
                    }
                }
                LOG.info("Processing events of type {} done.", (Object)type);
            });
        } else {
            LOG.error("Can not process events, EventQueueProcessor is not set.");
        }
    }

    @Override
    public long getQueueSize() {
        return this._updateEventQueueDAO.getQueueSize();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMultiWikiVersionCreated(MultiWikiVersionCreatedEvent e) {
        this.onChange(new EntityUpdateEvent(e.getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogPostingSaved(MicroblogPostingPublishedEvent e) {
        this.onChange(new MicroblogUpdateEvent(e.getWorkstreamMessageId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogPostingUpdated(MicroblogPostingUpdatedEvent e) {
        this.onChange(new MicroblogUpdateEvent(e.getWorkstreamMessageId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentCreated(CommentCreatedEvent e) {
        this.handleUpdateComment(e.getComment().getParentId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentUpdated(CommentUpdatedEvent e) {
        this.handleUpdateComment(e.getParentId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onItemDeleted(final ItemDeletedEvent e) {
        GlobalId id = e.getItemId();
        id.accept(new DefaultItemIdVisitor<Object>(){

            @Override
            public Object visitDefault(ItemId globalId) {
                return this;
            }

            @Override
            public Object visit(WorkstreamMessageId workstreamMessageId) {
                DatabaseQueueUpdateEventHandlerImpl.this.onChange(new MicroblogUpdateEvent(workstreamMessageId));
                return this;
            }

            @Override
            public Object visit(CommentId commentId) {
                if (e instanceof CommentDeletedEvent) {
                    DatabaseQueueUpdateEventHandlerImpl.this.handleUpdateComment(((CommentDeletedEvent)e).getComment().getParentId());
                }
                return this;
            }
        });
        WorkstreamMessageId workstreamEntryId = (WorkstreamMessageId)this._workstreamService.getMicroblogEntryIdsByAttachments((Set<? extends ItemId>)ImmutableSet.of((Object)id)).get((Object)id);
        if (workstreamEntryId != null) {
            this.onChange(new MicroblogUpdateEvent(workstreamEntryId));
        }
    }

    private void handleUpdateComment(ItemId parentId) {
        if (parentId instanceof GlobalId) {
            this.onChange(new CommentParentUpdateEvent((GlobalId)parentId));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onWorkstreamModuleDeleted(WorkstreamModuleDeletedEvent e) {
        this.onChanges((Iterable<? extends UpdateEvent<?>>)FluentIterable.from(e.getDeletedMicroblogs()).transform(MicroblogUpdateEvent.FROM_WORKSTREAM_MESSAGE_ID).filter(Predicates.notNull()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onProfileVisibilitiesChanged(ProfileVisibilitiesChangedEvent e) {
        this.onChange(new ProfileVisibilitiesUpdateEvent(e.getProfileId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewContact(NewContactEvent e) {
        this.handleContactUpdated(e.getAcceptorId(), e.getRequesterId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRemoveContact(RemoveContactEvent e) {
        this.handleContactUpdated(e.getPersonId(), e.getFriendId());
    }

    private void handleContactUpdated(PersonId personId, PersonId friendId) {
        this.onChanges((Iterable<? extends UpdateEvent<?>>)ImmutableList.of((Object)new ContactUpdateEvent(personId.asProfileId()), (Object)new ContactUpdateEvent(friendId.asProfileId())));
        this.onChange(new PersonUpdateEvent(personId.asProfileId()));
        this.onChange(new PersonUpdateEvent(friendId.asProfileId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionPublished(EntityVersionPublishedEvent e) {
        if (e.getVersion().getStatus().isPublished()) {
            this.onChange(new EntityVersionPublishedUpdateEvent(e.getVersion().getEntityId()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionArchived(EntityVersionArchivedEvent e) {
        this.onChange(new EntityVersionArchivedUpdateEvent(e.getVersion().getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMembershipChanged(EntityMembershipChangedEvent e) {
        this.onChange(new EntityMemberUpdateEvent(e.getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMemberRolesChanged(EntityMemberRolesChangedEvent e) {
        this.onChange(new EntityMemberUpdateEvent(e.getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityAdminChanged(EntityAdminChangedEvent e) {
        this.onChange(new EntityAdminUpdateEvent(e.getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityDescriptionUpdate(EntityDescriptionUpdatedEvent e) {
        this.onChange(new EntityUpdateEvent(e.getEntity().getId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionStatusUpdate(EntityVersionStatusUpdateEvent event) {
        this.onChange(new EntityVersionStatusUpdatedEvent(event.getVersion().getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConversationUpdatedEvent(ConversationUpdatedEvent event) {
        if (!event.isNewConversation()) {
            this.onChange(new ConversationUpdateEvent(event.getConversationId()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConversationDeletedEvent(ConversationDeletedEvent event) {
        this.onChange(new ConversationDeleteEvent(event.getConversationId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityComponentPositionsChanged(EntityComponentPositionsChangedEvent e) {
        this.onChange(new EntityUpdateEvent(e.getEntityId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityNameUpdated(EntityNameUpdatedEvent e) {
        if (this._settings.isIndexPathEnabled()) {
            this.onChange(new EntityNameUpdateEvent(e.getEntityId()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onChatMessageAddedOrDeleted(ChatMessageAddedOrDeletedEvent event) {
        ChatMessageType type = event.getMessage().getType();
        if (type == ChatMessageType.CHAT_MESSAGE || type == ChatMessageType.ATTACHMENT_CHAT_MESSAGE || type == ChatMessageType.CONVERSATION_CREATED || type == ChatMessageType.DELETED_CHAT_MESSAGE) {
            this.onChange(new ChatMessageUpdateEvent(event.getMessage().getId()));
        }
    }

    private void notifyPersonUpdate(PersonId personId) {
        this.onChange(new PersonUpdateEvent(personId.asProfileId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonUpdatedEvent(PersonUpdatedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonActivatedEvent(PersonActivatedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeactivatedEvent(PersonDeactivatedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onProfileChangedEvent(ProfileChangedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonBlockedEvent(PersonBlockedStatusChangedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonRolesChangedEvent(PersonRolesChangedEvent event) {
        this.notifyPersonUpdate(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogAttachmentDeletedEvent(MicroblogAttachmentDeletedEvent event) {
        this.onChange(new MicroblogUpdateEvent(event.getWorkstreamMessageId()));
    }

    @ParametersAreNonnullByDefault
    private static enum EventToTypeVisitor implements UpdateEventVisitor<UpdateEventType>
    {
        INSTANCE;


        @Override
        public UpdateEventType visitEntity(EntityUpdateEvent event) {
            return UpdateEventType.ENTITY_UPDATED;
        }

        @Override
        public UpdateEventType visitPerson(PersonUpdateEvent event) {
            return UpdateEventType.PROFILE_UPDATED;
        }

        @Override
        public UpdateEventType visitProfileVisibilities(ProfileVisibilitiesUpdateEvent event) {
            return UpdateEventType.PROFILE_VISIBILITIES_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityMember(EntityMemberUpdateEvent event) {
            return UpdateEventType.ENTITY_MEMBERSHIP_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityAdmin(EntityAdminUpdateEvent event) {
            return UpdateEventType.ENTITY_ADMIN_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityParent(EntityParentUpdateEvent event) {
            return UpdateEventType.ENTITY_PARENT_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityName(EntityNameUpdateEvent event) {
            return UpdateEventType.ENTITY_NAME_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityVisibilities(EntityVisibilitiesUpdateEvent event) {
            return UpdateEventType.ENTITY_VISIBILITIES_UPDATED;
        }

        @Override
        public UpdateEventType visitWorkstream(MicroblogUpdateEvent event) {
            return UpdateEventType.WORKSTREAM_UPDATED;
        }

        @Override
        public UpdateEventType visitContact(ContactUpdateEvent event) {
            return UpdateEventType.PROFILE_CONTACT_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityVersionPublished(EntityVersionPublishedUpdateEvent event) {
            return UpdateEventType.ENTITY_VERSION_PUBLISHED;
        }

        @Override
        public UpdateEventType visitEntityVersionArchived(EntityVersionArchivedUpdateEvent event) {
            return UpdateEventType.ENTITY_ARCHIVED;
        }

        @Override
        public UpdateEventType visitCommentParentUpdate(CommentParentUpdateEvent event) {
            return UpdateEventType.COMMENT_PARENT_UPDATE;
        }

        @Override
        public UpdateEventType visitSubscriberUpdate(SubscriberUpdateEvent event) {
            return UpdateEventType.SUBSCRIBER_UPDATE;
        }

        @Override
        public UpdateEventType visitEntityVersionStatusUpdated(EntityVersionStatusUpdatedEvent entityVersionStatusUpdatedEvent) {
            return UpdateEventType.ENTITY_VERSION_STATUS_UPDATED;
        }

        @Override
        public UpdateEventType visitEntityModifyDate(EntityUpdateModifyDateEvent entityUpdateModifyDate) {
            return UpdateEventType.ENTITY_MODIFY_DATE_UPDATED;
        }

        @Override
        public UpdateEventType visitPersonModifyDate(PersonModifyDateUpdateEvent personModifyDateUpdateEvent) {
            return UpdateEventType.PROFILE_MODIFY_DATE_UPDATED;
        }

        @Override
        public UpdateEventType visitConversationUpdate(ConversationUpdateEvent conversationUpdateEvent) {
            return UpdateEventType.CONVERSATION_UPDATED;
        }

        @Override
        public UpdateEventType visitConversationDelete(ConversationDeleteEvent conversationUpdateEvent) {
            return UpdateEventType.CONVERSATION_DELETED;
        }

        @Override
        public UpdateEventType visitChatMessageUpdate(ChatMessageUpdateEvent chatMessageUpdateEvent) {
            return UpdateEventType.CHAT_MESSAGE_UPDATED;
        }
    }
}

