/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.DriveAction;
import de.justsoftware.onx.drive.business.ItemPrivacyProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerState;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ItemPrivacyProducerImpl
implements ItemPrivacyProducer {
    private static final String TOPIC = "just.item.actions";
    private static final Logger LOG = LoggerFactory.getLogger(ItemPrivacyProducerImpl.class);
    private static final Callback LOG_ERROR_CALLBACK = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                LOG.error("Could not publish item privacy settings", (Throwable)exception);
            }
        }
    };
    private final KafkaCleaningProducer<String, String> _producer;

    @Autowired
    public ItemPrivacyProducerImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        this._producer = producer;
    }

    @Override
    public void sendDelete(ItemId itemId) {
        if (this.isReady()) {
            this._producer.send(new ProducerRecord(TOPIC, (Object)itemId.asString(), null), LOG_ERROR_CALLBACK);
        }
    }

    @Override
    public boolean isReady() {
        return this._producer != null;
    }

    @Override
    public void send(ItemId id, Map<DriveAction, BoolExpr> actions) {
        try {
            JSONObject o = new JSONObject();
            for (Map.Entry<DriveAction, BoolExpr> e : actions.entrySet()) {
                o.put(e.getKey().getName(), (Object)e.getValue().toString());
            }
            this._producer.send(new ProducerRecord(TOPIC, (Object)id.asString(), (Object)o.toString()), LOG_ERROR_CALLBACK);
        }
        catch (JSONException e1) {
            LOG.error("Could not send JSON to Kafka", (Throwable)e1);
        }
    }

    @Override
    public void republish(Runnable republishAction) {
        if (this.isReady()) {
            try (KafkaCleaningProducerState state = this._producer.beginRefill(new String[]{TOPIC});){
                republishAction.run();
                state.finishRefill();
            }
        }
    }
}

