/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.events.DriveShareAccessRequestEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class DriveShareAccessRequestNotificationCreator
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.drive.shares.accessRequests";
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveShareAccessRequestNotificationCreator.class);
    private final JCEventBus _eventBus;

    @Autowired
    public DriveShareAccessRequestNotificationCreator(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionHelper transactionHelper, JCEventBus eventBus) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.DriveShareAccessRequestNotificationCreator"), transactionHelper, eventBus);
    }

    @VisibleForTesting
    DriveShareAccessRequestNotificationCreator(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, JCEventBus eventBus) {
        super(consumer, transactionHelper, TOPIC);
        this._eventBus = eventBus;
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            this.process((ConsumerRecord<String, String>)record, context);
        }
    }

    @Override
    @VisibleForTesting
    void process(ConsumerRecord<String, String> record, KafkaConsumerContext context) {
        JsonNode payload;
        String key = (String)record.key();
        if (key == null) {
            return;
        }
        ItemId parsedItemId = ItemId.parseSafe(key);
        if (parsedItemId == null || !(parsedItemId instanceof DriveShareId)) {
            LOGGER.warn("Got Drive Share access request without or with improper Share ID: {}", (Object)key);
            return;
        }
        DriveShareId shareItemId = (DriveShareId)parsedItemId;
        String value = (String)record.value();
        JsonNode jsonNode = payload = value == null ? null : this.parseJson(value);
        if (payload == null) {
            LOGGER.warn("Got Drive Share access request without payload", (Object)key);
            return;
        }
        PersonId requestor = PersonId.parse((String)DriveShareAccessRequestNotificationCreator.parseString(payload, "requestor").orNull());
        if (requestor == null) {
            LOGGER.warn("Got Drive Share access request without requestor: {}", (Object)payload);
            return;
        }
        String shareName = (String)DriveShareAccessRequestNotificationCreator.parseString(payload, "name").orNull();
        if (shareName == null) {
            LOGGER.warn("Got Drive Share access request without Share name: {}", (Object)payload);
            return;
        }
        DriveDocumentId rootFolderId = (DriveDocumentId)DriveShareAccessRequestNotificationCreator.parseString(payload, "rootFolderId").transform(DriveDocumentId::new).orNull();
        if (rootFolderId == null) {
            LOGGER.warn("Got Drive Share access request without root folder ID: {}", (Object)payload);
            return;
        }
        ImmutableSet admins = FluentIterable.from((Iterable)payload.path("admins")).transform(admin -> new PersonId(admin.asLong())).toSet();
        context.afterCommit(() -> this._eventBus.post(new DriveShareAccessRequestEvent(requestor, shareItemId, (ImmutableSet<PersonId>)admins, shareName)));
    }
}

