/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import de.justsoftware.onx.drive.business.DriveDocumentItemHandler;
import de.justsoftware.onx.drive.business.DriveDocumentItemService;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentPublicity;
import de.justsoftware.onx.drive.integration.persistence.DriveDocumentItemDAO;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DriveDocumentItemServiceImpl
implements DriveDocumentItemHandler,
DriveDocumentItemService {
    private final DriveDocumentItemDAO _driveDocumentItemDAO;

    @Autowired
    public DriveDocumentItemServiceImpl(DriveDocumentItemDAO driveDocumentItemDAO) {
        this._driveDocumentItemDAO = driveDocumentItemDAO;
    }

    @Override
    public ImmutableMap<DriveDocumentId, DriveDocumentItem> getByIds(ImmutableSet<DriveDocumentId> ids) {
        return this.getByIds(DriveDocumentPublicity.PUBLIC, (Set<DriveDocumentId>)ids);
    }

    @Override
    public void storeItems(Table<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem> itemsToUpdate, SetMultimap<DriveDocumentPublicity, DriveDocumentId> itemsToDelete) {
        this._driveDocumentItemDAO.storeItems(itemsToUpdate, itemsToDelete);
    }

    @Override
    public ImmutableMap<DriveDocumentId, DriveDocumentItem> getByIds(DriveDocumentPublicity publicity, Set<DriveDocumentId> ids) {
        return this._driveDocumentItemDAO.getByIds(publicity, ids);
    }

    @Override
    public ImmutableMap<DriveDocumentId, DriveDocumentItem> getAnyByIds(Set<DriveDocumentId> ids) {
        ImmutableMap<DriveDocumentId, DriveDocumentItem> pub = this.getByIds(DriveDocumentPublicity.PUBLIC, ids);
        ImmutableMap<DriveDocumentId, DriveDocumentItem> priv = this.getByIds(DriveDocumentPublicity.PRIVATE, (Set<DriveDocumentId>)Sets.difference(ids, (Set)pub.keySet()));
        return ImmutableMap.builder().putAll(pub).putAll(priv).build();
    }
}

