/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.DriveDocumentUpdatedEvent;
import de.justsoftware.onx.container.business.events.DriveDocumentsDeletedEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.DriveDocumentItemService;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentPublicity;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class DriveDocumentItemConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.drive.documents";
    private static final Logger LOG = LoggerFactory.getLogger(DriveDocumentItemConsumer.class);
    private final DriveDocumentItemService _driveDocumentItemService;
    private final SearchIndexService _searchIndexService;
    private final JCEventBus _eventBus;
    private final ItemService _itemService;

    @Autowired
    public DriveDocumentItemConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, DriveDocumentItemService driveDocumentItemService, SearchIndexService searchIndexService, JCEventBus eventBus, ItemService itemService) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.DriveDocumentItemConsumer"), transactionHelper, driveDocumentItemService, searchIndexService, eventBus, itemService);
    }

    @VisibleForTesting
    DriveDocumentItemConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, DriveDocumentItemService driveDocumentItemService, SearchIndexService searchIndexService, JCEventBus eventBus, ItemService itemService) {
        super(consumer, transactionHelper, TOPIC);
        this._driveDocumentItemService = driveDocumentItemService;
        this._searchIndexService = searchIndexService;
        this._eventBus = eventBus;
        this._itemService = itemService;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        HashBasedTable items = HashBasedTable.create();
        HashMultimap itemsToDelete = HashMultimap.create();
        for (ConsumerRecord record : records) {
            this.process((ConsumerRecord<String, String>)record, (HashBasedTable<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem>)items, (HashMultimap<DriveDocumentPublicity, DriveDocumentId>)itemsToDelete);
        }
        this._driveDocumentItemService.storeItems((Table<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem>)items, (SetMultimap<DriveDocumentPublicity, DriveDocumentId>)itemsToDelete);
        ImmutableSet documentIdsToDelete = ImmutableSet.copyOf((Collection)itemsToDelete.values());
        if (!documentIdsToDelete.isEmpty()) {
            this._eventBus.post(new DriveDocumentsDeletedEvent((ImmutableSet<DriveDocumentId>)documentIdsToDelete));
        }
        List updateEvents = items.values().stream().map(document -> new DriveDocumentUpdatedEvent(document.getId(), document.getChangeDate())).collect(Collectors.toList());
        this._eventBus.post(updateEvents);
        this._searchIndexService.queueItemsForIndex((Set<DBSearchIndexQueueEntry>)DBSearchIndexQueueEntry.fromItemIds(items.row((Object)DriveDocumentPublicity.PUBLIC).keySet(), SearchIndexType.SUBSCRIBERS, SearchIndexType.PARENTS));
    }

    private void process(ConsumerRecord<String, String> record, HashBasedTable<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem> items, HashMultimap<DriveDocumentPublicity, DriveDocumentId> itemsToDelete) {
        String[] split = StringUtils.split((String)((String)record.key()), (char)';');
        if (split.length != 2) {
            LOG.warn("Key has wrong format");
            return;
        }
        DriveDocumentId documentId = new DriveDocumentId(split[0]);
        DriveDocumentPublicity publicity = this.parsePublicity(split[1], record);
        if (publicity == null) {
            return;
        }
        String value = (String)record.value();
        if (value == null) {
            itemsToDelete.put((Object)publicity, (Object)documentId);
            items.remove((Object)publicity, (Object)documentId);
            return;
        }
        JsonNode parsedJson = this.parseJson(value);
        if (parsedJson == null) {
            LOG.warn("not parsable json content found: {}", record);
            return;
        }
        ItemId parent = ItemId.parseSafe((String)DriveDocumentItemConsumer.parseString(parsedJson, "itemId").orNull());
        if (parent == null) {
            LOG.warn("unparsable or missing field itemId: {}", record);
            return;
        }
        String name = (String)DriveDocumentItemConsumer.parseString(parsedJson, "name").orNull();
        if (name == null) {
            LOG.warn("unparsable or missing field name: {}", record);
            return;
        }
        DateTime changeDate = (DateTime)DriveDocumentItemConsumer.parseDate(parsedJson, "changeDate").orNull();
        if (changeDate == null) {
            LOG.warn("unparsable or missing field changeDate: {}", record);
            return;
        }
        items.put((Object)publicity, (Object)documentId, (Object)new DriveDocumentItem(documentId, publicity, parent, name, DriveDocumentItemConsumer.parseLong(parsedJson, "fileSize", 0L), (String)DriveDocumentItemConsumer.parseString(parsedJson, "mimeType").or((Object)""), changeDate));
        itemsToDelete.remove((Object)publicity, (Object)documentId);
    }

    @CheckForNull
    private DriveDocumentPublicity parsePublicity(String s, ConsumerRecord<String, String> record) {
        switch (s) {
            case "PUBLIC": {
                return DriveDocumentPublicity.PUBLIC;
            }
            case "PRIVATE": {
                return DriveDocumentPublicity.PRIVATE;
            }
        }
        LOG.warn("unknown publicity found, record ignored: {}", record);
        return null;
    }
}

