/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.DocumentVersionId;
import de.justsoftware.onx.document.shared.model.db.DBDocumentVersion;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentVersionItem
implements Item<DocumentVersionId> {
    public static final Function<DBDocumentVersion, DocumentVersionItem> FROM_DBVERSION = new Function<DBDocumentVersion, DocumentVersionItem>(){

        public DocumentVersionItem apply(DBDocumentVersion input) {
            return DocumentVersionItem.of(input);
        }
    };
    private final DBDocumentVersion _version;

    public DocumentVersionItem(@Nonnull DBDocumentVersion version) {
        this._version = version;
    }

    @CheckForNull
    public static DocumentVersionItem of(@Nullable DBDocumentVersion version) {
        return version != null ? new DocumentVersionItem(version) : null;
    }

    @Nonnull
    public DBDocumentVersion getVersion() {
        return this._version;
    }

    @Override
    public DocumentVersionId getId() {
        return this._version.getId();
    }

    @Override
    @Nonnull
    public DocumentId getParentId() {
        return this._version.getDocumentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.DOCUMENT;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this._version).toString();
    }
}

