/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.db.DBDocument;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentItem
implements Item<DocumentId> {
    public static final Function<DBDocument, DocumentItem> FROM_DBDOCUMENT = new Function<DBDocument, DocumentItem>(){

        public DocumentItem apply(DBDocument input) {
            return DocumentItem.of(input);
        }
    };
    private final DBDocument _document;

    public DocumentItem(@Nonnull DBDocument document) {
        this._document = document;
    }

    @CheckForNull
    public static DocumentItem of(@Nullable DBDocument document) {
        return document != null ? new DocumentItem(document) : null;
    }

    @Nonnull
    public DBDocument getDocument() {
        return this._document;
    }

    @Override
    public DocumentId getId() {
        return this._document.getId();
    }

    @Override
    public GlobalId getParentId() {
        return this._document.getParentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.DOCUMENT;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("document", (Object)this._document).toString();
    }
}

