/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.document.integration.persistence.DocumentDAO;
import de.justsoftware.onx.document.server.model.DBDocumentAccessToken;
import de.justsoftware.onx.document.server.model.DocumentAccessTokenId;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.DocumentOrder;
import de.justsoftware.onx.document.shared.model.DocumentVersionId;
import de.justsoftware.onx.document.shared.model.ExternalDocumentId;
import de.justsoftware.onx.document.shared.model.FileType;
import de.justsoftware.onx.document.shared.model.db.DBDocument;
import de.justsoftware.onx.document.shared.model.db.DBDocumentVersion;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="mdlDocumentDAO")
public class IbatisDocumentDAO
implements DocumentDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisDocumentDAO.class);
    private static final String NAMESPACE = "MdlDocument.";
    private final SqlMapClient _sqlMapClient;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisDocumentDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapClient = sqlMapper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("MdlDocument");
    }

    @Override
    public DBDocument getDocumentById(DocumentId id) {
        return (DBDocument)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "MdlDocument.getDocumentById", id);
    }

    @Override
    public List<DBDocumentVersion> getDocumentVersionsByDocumentId(DocumentId id) {
        LOG.debug("Getting all version for document " + id.getId());
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentVersionsByDocumentId", id);
    }

    @Override
    public List<DBDocumentVersion> getDocumentVersionsByUploader(PersonId uploader, int offset, int count) {
        LOG.debug("Getting all version for uploader " + uploader);
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentVersionsByUploader", uploader, offset, count);
    }

    @Override
    public DBDocumentVersion getCurrentVersionByDocumentId(DocumentId id) {
        return (DBDocumentVersion)IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentVersionsByDocumentId", id).get(0);
    }

    @Override
    public List<FileType> getFileTypes() {
        return IbatisDAOUtil.wrappedQueryForList(FileType.class, this._sqlMapClient, "MdlDocument.getFileTypes");
    }

    @Override
    public Map<String, FileType> getFileTypesMap() {
        return IbatisDAOUtil.wrappedQueryForMap(this._sqlMapClient, "MdlDocument.getFileTypes", null, "extension");
    }

    @Override
    public int setCheckedOutById(DocumentId id, PersonId personId, Date timestamp) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(3);
        params.put("documentId", id);
        params.put("userId", personId);
        params.put("timestamp", timestamp);
        return IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.setCheckedOutById", params);
    }

    @Override
    public void deleteDocumentsByIds(Set<DocumentId> ids) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapClient, "MdlDocument.deleteDocumentsByIds", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public Map<DocumentVersionId, DBDocumentVersion> getDocumentVersionsByIds(Set<? extends DocumentVersionId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapClient, "MdlDocument.getDocumentVersionsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableSetMultimap<DocumentId, DocumentVersionId> getDocumentVersionIdsByDocumentIds(Set<? extends DocumentId> documentIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForSetMultimap(this._sqlMapClient, "MdlDocument.getDocumentVersionIdsByDocumentIds", "key", "value", documentIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public List<DocumentVersionId> getDocumentVersionIdsReferencingSameFile(DBDocumentVersion restoredFromVersion) {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentVersionsIdsWithSameUrl", restoredFromVersion);
    }

    @Override
    public Integer deleteDocumentVersionByIdWithVersionCountCheck(DocumentVersionId id) {
        return IbatisDAOUtil.wrappedDelete(this._sqlMapClient, "MdlDocument.deleteDocumentVersionByIdWithVersionCountCheck", id);
    }

    @Override
    public Map<DocumentId, DBDocument> getDocumentsByIds(Set<DocumentId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapClient, "MdlDocument.getDocumentsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public List<DocumentId> getDocumentIdsByParentId(GlobalId id, DocumentOrder order) {
        switch (order) {
            case DATE: {
                return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentIdsByParentIdOrderByDate", id.asMap());
            }
            case FILENAME: {
                return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentIdsByParentIdOrderByFilename", id.asMap());
            }
            case UPLOADED_BY: {
                return IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getDocumentIdsByParentIdOrderByUploadedBy", id.asMap());
            }
        }
        throw new UnsupportedOperationException("Sorting in order " + order.name() + " not implemented!");
    }

    @Override
    public void resetCheckOutState(DocumentId id) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.resetCheckOutState", id);
    }

    @Override
    public void resetDownloadCount(DocumentId id) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.resetDownloadCount", id);
    }

    @Override
    public DocumentVersionId addDocumentVersion(DBDocumentVersion version, boolean notifiedOthers) {
        DocumentVersionId res = (DocumentVersionId)IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "MdlDocument.insertDocumentVersion", ImmutableMap.of((Object)"version", (Object)version, (Object)"notifiedOthers", (Object)notifiedOthers));
        this.setModifiedAt(version.getDocumentId(), version.getUploadedAt());
        return res;
    }

    @Override
    public DocumentId addFileDocument(DBDocument document) {
        return (DocumentId)IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "MdlDocument.insertDocument", document);
    }

    @Override
    public Map<DocumentId, DBDocumentVersion> getCurrentDocumentVersionsByDocumentIds(Iterable<DocumentId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapClient, "MdlDocument.getCurrentDocumentVersionsByDocumentIds", "documentId", ImmutableSet.copyOf(ids), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void increaseDownloadCount(DocumentId id) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.increaseDownloadCount", id);
    }

    @Override
    public void deleteDocumentVersionsByIds(ImmutableSet<DocumentVersionId> ids) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapClient, "MdlDocument.deleteDocumentVersionsByIds", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void saveMetadata(DocumentId id, String description, String keywords, DBDocument.Status status, PersonId statusChangedBy, Date statusChangedAt, Date modifiedAt) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("description", description);
        params.put("keywords", keywords);
        params.put("status", status.getId());
        params.put("status_changed_by", statusChangedBy);
        params.put("status_changed_as", statusChangedAt);
        params.put("modified_at", modifiedAt);
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.saveMetadata", params);
    }

    @Override
    public ExternalDocumentId getJudoIdById(DocumentVersionId versionId) {
        String judoId = (String)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "MdlDocument.getJudoIdById", versionId);
        return judoId == null ? null : new ExternalDocumentId(judoId);
    }

    @Override
    public ImmutableMap<DocumentVersionId, String> getPreviewIds(Set<DocumentVersionId> documentVersionIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getPreviewIds").partition(documentVersionIds)).asMap("version_id", "judo_id");
    }

    @Override
    public void insertJudoId(DocumentVersionId versionId, ExternalDocumentId judoId) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "MdlDocument.insertJudoId", ImmutableMap.of((Object)"versionId", (Object)versionId, (Object)"judoId", (Object)judoId.getId()));
    }

    @Override
    public ImmutableList<DocumentVersionId> getVersionsWithoutJudoId(int limit) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "MdlDocument.getVersionsWithoutJudoId", null, 0, limit), DocumentVersionId.FROM_LONG));
    }

    @Override
    public int setModifiedAt(DocumentId documentId, Date modifiedAt) {
        return IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "MdlDocument.setModifiedAt", ImmutableMap.of((Object)"documentId", (Object)documentId, (Object)"modifiedAt", (Object)modifiedAt));
    }

    @Override
    public int createDocumentAccessToken(DocumentAccessTokenId token, DateTime tokenExpiry, String documentId) {
        try {
            ((Optional)this._statementBuilder.insert("insertDocumentAccessToken").param("token", token, "tokenExpiry", tokenExpiry, "documentId", documentId)).orNull();
            return 1;
        }
        catch (DAOException e) {
            LOG.error("Error inserting document access token {} : {}", (Object)documentId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int deleteDocumentAccessTokens(Set<DocumentAccessTokenId> tokens) {
        if (Iterables.isEmpty(tokens)) {
            return 0;
        }
        try {
            return (Integer)this._statementBuilder.delete("deleteDocumentAccessTokens").partition(tokens);
        }
        catch (DAOException e) {
            LOG.error("Error deleting document access tokens {} : {}", tokens, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public DBDocumentAccessToken getDocumentAccessToken(DocumentAccessTokenId token) {
        return (DBDocumentAccessToken)this._statementBuilder.select("getDocumentAccessToken").param(token.getId()).singleObject();
    }

    @Override
    public void removeTokensExpiredBefore(DateTime dateTime) {
        this._statementBuilder.delete("removeTokensExpiredBefore").param("dateTime", dateTime);
    }

    @Override
    public void forAllDocumentVersions(int chunkSize, Consumer<ImmutableList<DBDocumentVersion>> consumer) {
        ((IbatisStandardResultBuilder)this._statementBuilder.select("selectAllDocumentVersionsOrderedByUploadedAtAsc").noParam()).consumeChunkedList(chunkSize, consumer);
    }

    @Override
    public void forAllDocuments(int chunkSize, Consumer<ImmutableList<DBDocument>> consumer) {
        ((IbatisStandardResultBuilder)this._statementBuilder.select("selectAllDocumentsOrderedByIdAsc").noParam()).consumeChunkedList(chunkSize, consumer);
    }
}

