/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.business.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.DriveDocumentCommentStreamHandler;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentComment;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class DriveDocumentCommentStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<DriveDocumentComment>
implements DriveDocumentCommentStreamHandler {
    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return ImmutableSetMultimap.of();
    }

    @Override
    protected DriveDocumentComment convert(DBWorkstreamMessage m, PersonTeaserModel authorTeaser, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        ItemId itemId = m.getSubjectItemId();
        if (!(itemId instanceof DriveDocumentId)) {
            return null;
        }
        DriveDocumentId documentId = (DriveDocumentId)itemId;
        String documentName = (String)Preconditions.checkNotNull((Object)m.getAttribute("document_name"));
        return new DriveDocumentComment(m, authorTeaser, may, documentId, documentName);
    }
}

