/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.business.impl;

import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.document.business.DocumentService;
import de.justsoftware.onx.document.integration.persistence.DocumentDAO;
import de.justsoftware.onx.document.server.model.DBDocumentAccessToken;
import de.justsoftware.onx.document.server.model.DocumentAccessTokenId;
import de.justsoftware.onx.document.shared.model.FileType;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="documentService")
public class DocumentServiceImpl
implements DocumentService {
    private static final CacheKey FILE_TYPES_KEY = new CacheKey((CacheName)DocumentServiceCacheName.GENERIC, "DOCUMENT_FILE_TYPES");
    private static final CacheKey FILE_TYPES = new CacheKey((CacheName)DocumentServiceCacheName.GENERIC, "FILE_TYPES");
    private static final int DOCUMENT_ACCESS_TOKEN_VALIDITY = 300000;
    private final CacheHelper _cacheHelper;
    private final Clock _clock;
    private final DocumentDAO _documentDAO;

    @ParametersAreNonnullByDefault
    @Autowired
    public DocumentServiceImpl(DocumentDAO documentDAO, CacheHelper cacheHelper, Clock clock) {
        this._documentDAO = documentDAO;
        this._cacheHelper = cacheHelper;
        this._clock = clock;
    }

    @Override
    public String getIconUrl(String fileName) {
        return this.getFileTypeByFileName(fileName).getIconUrl();
    }

    @Override
    public Map<Long, FileType> getFileTypes() {
        return this._cacheHelper.getFromCache(FILE_TYPES_KEY, () -> {
            HashMap<Long, FileType> ftMap = new HashMap<Long, FileType>();
            for (FileType t : this._documentDAO.getFileTypes()) {
                ftMap.put(t.getId(), t);
            }
            return ftMap;
        });
    }

    @Nonnull
    private Map<String, FileType> getFileTypesMap() {
        return this._cacheHelper.getFromCache(FILE_TYPES, this._documentDAO::getFileTypesMap);
    }

    @Override
    public Map<Long, FileType> getFileTypesByIds(Collection<Long> ids) {
        Map<Long, FileType> allTypes = this.getFileTypes();
        HashMap<Long, FileType> res = new HashMap<Long, FileType>(allTypes.size());
        for (FileType t : allTypes.values()) {
            res.put(t.getId(), t);
        }
        return res;
    }

    @Override
    public FileType getFileTypeByFileName(String filename) {
        return this.getFileTypeByMimeTypeOrFileName(null, filename);
    }

    @Override
    public FileType getFileTypeByMimeTypeOrFileName(String mimeType, String filename) {
        Map<String, FileType> types = this.getFileTypesMap();
        if (StringUtils.isNotBlank((String)mimeType)) {
            for (FileType type : types.values()) {
                if (!type.getMimeType().equals(mimeType)) continue;
                return type;
            }
        }
        if (StringUtils.isNotBlank((String)filename)) {
            String lowerFilename = filename.toLowerCase();
            for (FileType type : types.values()) {
                if (!lowerFilename.endsWith("." + type.getExtension())) continue;
                return type;
            }
        }
        return types.get("");
    }

    @Override
    public boolean isDocumentAccessTokenValid(DocumentAccessTokenId token, ItemId documentId) {
        return this.isDocumentAccessTokenValid(token, documentId.asString());
    }

    @Override
    public boolean isDocumentAccessTokenValid(DocumentAccessTokenId token, String documentId) {
        DBDocumentAccessToken accessToken = this._documentDAO.getDocumentAccessToken(token);
        if (accessToken == null) {
            return false;
        }
        return documentId.equals(accessToken.getDocumentId()) && !this.checkTokenExpired(accessToken);
    }

    private boolean checkTokenExpired(@Nonnull DBDocumentAccessToken token) {
        boolean isExpired = token.getTokenExpiry().isBefore((ReadableInstant)this._clock.now());
        if (isExpired) {
            this._documentDAO.deleteDocumentAccessTokens((Set<DocumentAccessTokenId>)ImmutableSet.of((Object)token.getToken()));
        }
        return isExpired;
    }

    @Override
    public DocumentAccessTokenId createDocumentAccessToken(ItemId documentId) {
        return this.createDocumentAccessToken(documentId.asString());
    }

    @Override
    public DocumentAccessTokenId createDocumentAccessToken(String documentId) {
        DateTime tokenExpiry;
        DocumentAccessTokenId token = this.createNewToken();
        int rowsAffected = this._documentDAO.createDocumentAccessToken(token, tokenExpiry = this._clock.now().plusMillis(300000), documentId);
        return rowsAffected == 1 ? token : null;
    }

    @Nonnull
    private DocumentAccessTokenId createNewToken() {
        return new DocumentAccessTokenId(UUID.randomUUID().toString());
    }

    @Override
    public void deleteExpiredDocumentAccessTokens() {
        this._documentDAO.removeTokensExpiredBefore(this._clock.now());
    }

    private static enum DocumentServiceCacheName implements CacheName
    {
        GENERIC("DocumentService.Generic");

        private final String _cacheName;

        private DocumentServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }
}

