/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.design.shared.model.IThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ThemeAttribute
implements IThemeAttribute {
    public static final Function<IThemeAttribute, ThemeAttribute> FROM_ITHEME_ELEMENT = new Function<IThemeAttribute, ThemeAttribute>(){

        public ThemeAttribute apply(IThemeAttribute input) {
            if (input == null) {
                return null;
            }
            return new ThemeAttribute(input);
        }
    };
    public static final Function<ThemeAttribute, ThemeAttributeType> TO_TYPE = new Function<ThemeAttribute, ThemeAttributeType>(){

        public ThemeAttributeType apply(ThemeAttribute attribute) {
            return attribute.getAttributeType();
        }
    };
    private final ThemeId _themeId;
    private final String _value;
    private final ThemeAttributeType _attributeType;

    private ThemeAttribute(IThemeAttribute origin) {
        this(origin.getThemeId(), origin.getValue(), origin.getAttributeType());
    }

    public ThemeAttribute(@Nullable ThemeId themeId, @Nullable String value, ThemeAttributeType attributeType) {
        this._themeId = themeId;
        this._value = value;
        this._attributeType = attributeType;
    }

    @Nonnull
    public static ThemeAttribute copyOf(IThemeAttribute origin) {
        return new ThemeAttribute(origin);
    }

    @Override
    public ThemeId getThemeId() {
        return this._themeId;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public ThemeAttributeType getAttributeType() {
        return this._attributeType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("themeId", (Object)this._themeId).add("value", (Object)this._value).add("attribute", (Object)this._attributeType).toString();
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._value, this._attributeType};
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ThemeAttribute && Arrays.equals(this.getHashObjects(), ((ThemeAttribute)obj).getHashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getHashObjects());
    }
}

