/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.LazyLoader;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@Deprecated
public final class Theme
implements ITheme {
    public static final Function<ITheme, Theme> FROM_ITHEME = new NullPermeableFunction<ITheme, Theme>(){

        @Override
        protected Theme applySafe(ITheme input) {
            return new Theme(input);
        }
    };
    public static final Function<Theme, ThemeId> TO_ID = new NullPermeableFunction<Theme, ThemeId>(){

        @Override
        protected ThemeId applySafe(Theme input) {
            return input.getId();
        }
    };
    private final ThemeId _id;
    private final String _name;
    private final boolean _defaultTheme;
    private final ImmutableSet<ThemeAttribute> _elements;
    private final LazyLoader<ImmutableMap<ThemeAttributeType, ThemeAttribute>> _byAttributeType = new LazyLoader<ImmutableMap<ThemeAttributeType, ThemeAttribute>>(){

        @Override
        protected ImmutableMap<ThemeAttributeType, ThemeAttribute> load() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            HashSet collected = Sets.newHashSet();
            for (ThemeAttribute attr : Theme.this._elements) {
                ThemeAttributeType attributeType = attr.getAttributeType();
                if (!collected.add(attributeType)) continue;
                builder.put((Object)attributeType, (Object)attr);
            }
            return builder.build();
        }
    };

    private Theme(ITheme copyFrom) {
        this(copyFrom.getId(), copyFrom.getName(), (ImmutableSet<ThemeAttribute>)FluentIterable.from(copyFrom.getThemeAttributes()).transform(ThemeAttribute.FROM_ITHEME_ELEMENT).filter(Predicates.notNull()).toSet(), copyFrom.isDefaultTheme());
    }

    public Theme(ThemeId id, @Nullable String name, ImmutableSet<ThemeAttribute> elements) {
        this(id, name, elements, false);
    }

    private Theme(ThemeId id, @Nullable String name, ImmutableSet<ThemeAttribute> elements, boolean defaultTheme) {
        this._id = id;
        this._name = name;
        this._elements = elements;
        this._defaultTheme = defaultTheme;
    }

    @Nonnull
    public static Theme copyWithNewAttributes(ITheme theme, ImmutableSet<ThemeAttribute> attributes) {
        return new Theme(theme.getId(), theme.getName(), (ImmutableSet<ThemeAttribute>)ImmutableSet.copyOf(attributes), theme.isDefaultTheme());
    }

    @Nonnull
    public static Theme copyOf(ITheme theme) {
        return new Theme(theme);
    }

    @Override
    @Nonnull
    public ThemeId getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public ImmutableSet<ThemeAttribute> getThemeAttributes() {
        return this._elements;
    }

    @Override
    public boolean isDefaultTheme() {
        return this._defaultTheme;
    }

    @CheckForNull
    public ThemeAttribute getAttribute(ThemeAttributeType type) {
        return (ThemeAttribute)this._byAttributeType.get().get((Object)type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("elements", this._elements).toString();
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._id, this._name, this._elements};
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof Theme && Arrays.equals(this.getHashObjects(), ((Theme)obj).getHashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getHashObjects());
    }
}

