/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface IThemeAttribute {
    public static final Function<IThemeAttribute, ThemeId> TO_THEME_ID = new Function<IThemeAttribute, ThemeId>(){

        public ThemeId apply(IThemeAttribute input) {
            return input != null ? input.getThemeId() : null;
        }
    };
    public static final Function<IThemeAttribute, ThemeAttributeType> TO_TYPE = new Function<IThemeAttribute, ThemeAttributeType>(){

        public ThemeAttributeType apply(IThemeAttribute input) {
            return input != null ? input.getAttributeType() : null;
        }
    };
    public static final Predicate<IThemeAttribute> IS_THEME_SPECIFIC = new NullIsFalsePredicate<IThemeAttribute>(){

        @Override
        protected boolean applySafe(IThemeAttribute theme) {
            return theme.getAttributeType().getScope() == ThemeAttributeType.Scope.ENTITY_THEME;
        }
    };
    public static final Predicate<IThemeAttribute> FOR_DEFAULT_THEME = new NullIsFalsePredicate<IThemeAttribute>(){

        @Override
        protected boolean applySafe(IThemeAttribute theme) {
            return theme.getAttributeType().getScope() == ThemeAttributeType.Scope.ENTITY_THEME || theme.getAttributeType().getScope() == ThemeAttributeType.Scope.DEFAULT_THEME;
        }
    };
    public static final Predicate<IThemeAttribute> GLOBAL_VARIABLE = new NullIsFalsePredicate<IThemeAttribute>(){

        @Override
        protected boolean applySafe(IThemeAttribute theme) {
            return theme.getAttributeType().getScope() == ThemeAttributeType.Scope.GLOBAL;
        }
    };

    @CheckForNull
    public ThemeId getThemeId();

    @CheckForNull
    public String getValue();

    @Nonnull
    public ThemeAttributeType getAttributeType();
}

