/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.design.persistence.ThemeDao;
import de.justsoftware.onx.design.persistence.model.DBTheme;
import de.justsoftware.onx.design.persistence.model.DBThemeAttribute;
import de.justsoftware.onx.design.shared.model.IThemeAttribute;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class IbatisThemeDao
implements ThemeDao {
    private static final String NAMESPACE = "Theme";
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapClient;
    @Autowired
    private TransactionHelper _transactionHelper;

    @Override
    public ThemeId createTheme(String name) {
        DBTheme theme = new DBTheme(name);
        return (ThemeId)IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "Theme.insertTheme", theme);
    }

    @Override
    public Theme getById(ThemeId themeId) {
        DBTheme theme = (DBTheme)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "Theme.selectById", themeId);
        return this.enrichToTheme(theme);
    }

    @CheckForNull
    private Theme enrichToTheme(@Nullable DBTheme theme) {
        if (theme == null) {
            return null;
        }
        ImmutableList elements = IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapClient, "Theme.selectThemeAttributesForTheme", theme.getId());
        theme.setThemeElements((Iterable<DBThemeAttribute>)elements);
        return Theme.copyOf(theme);
    }

    @Override
    public void updateTheme(final DBTheme theme) {
        final ThemeId themeId = theme.getId();
        if (themeId == null) {
            throw new IllegalArgumentException("themeId is null");
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisDAOUtil.wrappedUpdate(IbatisThemeDao.this._sqlMapClient, "Theme.updateTheme", theme);
                IbatisDAOUtil.wrappedDelete(IbatisThemeDao.this._sqlMapClient, "Theme.deleteThemeAttributesForTheme", themeId);
                if (!Iterables.isEmpty(theme.getThemeAttributes())) {
                    IbatisDAOUtil.executeInBatch(IbatisThemeDao.this._sqlMapClient, ImmutableList.copyOf(theme.getThemeAttributes()), 1000, (client, partitionPart) -> client.insert("Theme.insertThemeAttribute", (Object)ImmutableMap.of((Object)"attribute", (Object)partitionPart, (Object)"themeId", (Object)themeId)));
                }
            }
        });
    }

    @Override
    public ThemeId findThemeByEntityId(EntityId entityId) {
        return (ThemeId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "Theme.findThemeIdByEntityId", entityId);
    }

    @Override
    public Theme getDefaultTheme() {
        DBTheme dbTheme = (DBTheme)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "Theme.getDefaultTheme");
        return this.enrichToTheme(dbTheme);
    }

    @Override
    public void setDefaultTheme(ThemeId themeId) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "Theme.setDefaultTheme", themeId);
    }

    @Override
    public ImmutableList<Theme> getAvailableThemes() {
        ImmutableList dbThemes = IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapClient, "Theme.selectAllThemes");
        ImmutableList dbThemesElement = IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapClient, "Theme.selectAllThemeAttributes");
        ImmutableListMultimap elementMap = Multimaps.index(dbThemesElement, IThemeAttribute.TO_THEME_ID);
        for (DBTheme theme : dbThemes) {
            if (!elementMap.containsKey((Object)theme.getId())) continue;
            theme.setThemeElements((Iterable<DBThemeAttribute>)elementMap.get((Object)theme.getId()));
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(dbThemes, Theme.FROM_ITHEME));
    }
}

