/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleValueCache;
import de.justsoftware.onx.design.business.ThemeReadDataService;
import de.justsoftware.onx.design.business.ThemeWriteDataService;
import de.justsoftware.onx.design.persistence.ThemeDao;
import de.justsoftware.onx.design.persistence.model.DBTheme;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class ThemeReadWriteDataServiceImpl
implements ThemeReadDataService,
ThemeWriteDataService {
    private final ThemeDao _themeDao;
    private final ThemeByIdCacheAccessor _themeByIdCacheAccessor;
    private final DefaultThemeCacheAccessor _defaultThemeCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public ThemeReadWriteDataServiceImpl(EhcacheClient cache, ThemeDao themeDao) {
        this._themeDao = themeDao;
        this._themeByIdCacheAccessor = new ThemeByIdCacheAccessor(cache, themeDao);
        this._defaultThemeCacheAccessor = new DefaultThemeCacheAccessor(cache, themeDao);
    }

    @Override
    public ThemeId createTheme(String name) {
        ThemeId id = this._themeDao.createTheme(name);
        this._themeByIdCacheAccessor.invalidateKey(id);
        return id;
    }

    @Override
    public Theme getById(ThemeId themeId) {
        return this._themeByIdCacheAccessor.getFromDatabaseSingle(themeId);
    }

    @Override
    public void updateTheme(DBTheme theme) {
        ThemeId themeId = theme.getId();
        if (themeId == null) {
            throw new IllegalArgumentException("themeId is null");
        }
        this._themeDao.updateTheme(theme);
        this._themeByIdCacheAccessor.invalidateKey(themeId);
        this._defaultThemeCacheAccessor.invalidate();
    }

    @Override
    public Theme getDefaultTheme() {
        return (Theme)((Optional)this._defaultThemeCacheAccessor.get()).orNull();
    }

    @Override
    public void setDefaultTheme(ThemeId themeId) {
        this._themeDao.setDefaultTheme(themeId);
        this._defaultThemeCacheAccessor.invalidate();
    }

    @Override
    public ImmutableList<Theme> getAvailableThemes() {
        return this._themeDao.getAvailableThemes();
    }

    private static final class DefaultThemeCacheAccessor
    extends AbstractSingleValueCache<ThemeEhCacheNames, Optional<Theme>> {
        private final ThemeDao _themeDao;

        public DefaultThemeCacheAccessor(@Nonnull CacheClient<? super ThemeEhCacheNames> cache, @Nonnull ThemeDao themeDao) {
            super(cache, ThemeEhCacheNames.GENERIC, "default");
            this._themeDao = themeDao;
        }

        @Override
        protected Optional<Theme> getFromDatabase() {
            return Optional.fromNullable((Object)this._themeDao.getDefaultTheme());
        }
    }

    private static final class ThemeByIdCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<ThemeEhCacheNames, ThemeId, Theme> {
        private final ThemeDao _themeDao;

        private ThemeByIdCacheAccessor(@Nonnull CacheClient<? super ThemeEhCacheNames> cache, @Nonnull ThemeDao themeDao) {
            super(cache, ThemeEhCacheNames.BY_ID);
            this._themeDao = themeDao;
        }

        @Override
        protected Theme getFromDatabaseSingle(ThemeId input) {
            return this._themeDao.getById(input);
        }

        @Override
        protected String keyToString(ThemeId key) {
            return key.toString();
        }
    }

    public static enum ThemeEhCacheNames implements EhCacheName
    {
        BY_ID,
        GENERIC;


        @Override
        public String getCacheName() {
            return this.name();
        }
    }
}

