/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.server.model.validation.EntityDynamicAttributeValidationModel;
import de.justsoftware.onx.container.server.model.validation.constraint.ValidEntityWithAttributesConstraint;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import javax.annotation.Nonnull;
import javax.validation.Valid;

@ValidEntityWithAttributesConstraint
public class EntityWithDynamicAttributes {
    private final EntityType _type;
    private final ImmutableList<EntityDynamicAttributeValidationModel> _dynamicAttributes;

    public EntityWithDynamicAttributes(DBEntity entity) {
        this._type = entity.getType();
        this._dynamicAttributes = FluentIterable.from(entity.getDynamicAttributes()).transform(EntityDynamicAttributeValidationModel.validationModelFunctionForType(this._type)).toList();
    }

    @Nonnull
    public EntityType getType() {
        return this._type;
    }

    @Valid
    @Nonnull
    public ImmutableList<EntityDynamicAttributeValidationModel> getDynamicAttributes() {
        return this._dynamicAttributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("dynamicAttributes", this._dynamicAttributes).toString();
    }
}

