/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EntityItem
implements Item<EntityId> {
    public static final Function<DBEntity, EntityItem> FROM_DBENTITY = new Function<DBEntity, EntityItem>(){

        public EntityItem apply(DBEntity input) {
            return input != null ? new EntityItem(input) : null;
        }
    };
    public static final Function<EntityItem, DBEntity> TO_DBENTITY = new Function<EntityItem, DBEntity>(){

        public DBEntity apply(EntityItem input) {
            return input != null ? input.getEntity() : null;
        }
    };
    private final DBEntity _entity;

    public EntityItem(@Nonnull DBEntity entity) {
        this._entity = entity;
    }

    @CheckForNull
    public static EntityItem of(@Nullable DBEntity entity) {
        return entity != null ? new EntityItem(entity) : null;
    }

    @Nonnull
    public DBEntity getEntity() {
        return this._entity;
    }

    @Override
    public EntityId getId() {
        return this._entity.getId();
    }

    @Override
    public GlobalId getParentId() {
        return null;
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", (Object)this._entity).toString();
    }
}

