/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import javax.annotation.Nonnull;

public class EntityDynamicAttribute
implements IEntityDynamicAttribute {
    public static final Function<IEntityDynamicAttribute, EntityDynamicAttribute> FROM_INTERFACE = new Function<IEntityDynamicAttribute, EntityDynamicAttribute>(){

        public EntityDynamicAttribute apply(IEntityDynamicAttribute origin) {
            return origin != null ? new EntityDynamicAttribute(origin) : null;
        }
    };
    private final EntityId _entityId;
    private final DynamicAttributeId _attributeId;
    private final ImmutableList<String> _values;

    public EntityDynamicAttribute(@Nonnull EntityId entityId, @Nonnull DynamicAttributeId attributeId, @Nonnull ImmutableList<String> values) {
        this._entityId = entityId;
        this._attributeId = attributeId;
        this._values = values;
    }

    public EntityDynamicAttribute(@Nonnull IEntityDynamicAttribute origin) {
        this._entityId = origin.getEntityId();
        this._attributeId = origin.getAttributeId();
        this._values = origin.getValues();
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Override
    public DynamicAttributeId getAttributeId() {
        return this._attributeId;
    }

    @Override
    public ImmutableList<String> getValues() {
        return this._values;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("attributeId", (Object)this._attributeId).add("values", this._values == null ? null : Integer.valueOf(this._values.size())).toString();
    }
}

