/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.DefaultEntityTabVisitor;
import de.justsoftware.onx.container.shared.model.DynamicEntityTabCreator;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTabVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityTabUtils {
    public static final String DEFAULT_TAB_SUFFIX = "DEFAULT";

    @Nonnull
    public static ImmutableList<EntityTab> filterInactiveChildEntityTypeTabs(ImmutableSet<EntityType> activeEntityTypes, ImmutableList<EntityTab> entityTabs) {
        final ActiveChildEntityTypeVisitor tabActiveVisitor = new ActiveChildEntityTypeVisitor(activeEntityTypes);
        return FluentIterable.from(entityTabs).filter((Predicate)new NullIsFalsePredicate<EntityTab>(){

            @Override
            protected boolean applySafe(EntityTab input) {
                return (Boolean)input.accept(tabActiveVisitor);
            }
        }).toList();
    }

    @Nonnull
    public static EntityTab fromName(String name) {
        if (StringUtil.isBlank(name)) {
            return StaticEntityTab.DASHBOARD;
        }
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return StaticEntityTab.valueOf(parts[0]);
        }
        if (parts.length == 2 && DEFAULT_TAB_SUFFIX.equals(parts[1])) {
            return new DefaultEntityTab(StaticEntityTab.valueOf(parts[0]));
        }
        if (parts.length == 3 && DEFAULT_TAB_SUFFIX.equals(parts[2])) {
            return new DefaultEntityTab((EntityTab)DynamicEntityTabCreator.CHILD_ENTITIES.create(parts[1]));
        }
        return (EntityTab)DynamicEntityTabCreator.CHILD_ENTITIES.create(parts[1]);
    }

    @Nonnull
    public static EntityTab getSelectedDefaultTab(ImmutableList<EntityTab> availableTabs, @Nullable EntityTab entityDefaultTab) {
        if (entityDefaultTab == null || !availableTabs.contains((Object)entityDefaultTab)) {
            return EntityTabUtils.getDefaultTabFromAvailableTabs(availableTabs);
        }
        return entityDefaultTab;
    }

    @Nonnull
    public static EntityTab getDefaultTabFromAvailableTabs(ImmutableList<EntityTab> availableTabs) {
        return (EntityTab)FluentIterable.from(availableTabs).filter(tab -> !StaticEntityTab.SEPARATOR.equals(tab)).first().or((Object)StaticEntityTab.DASHBOARD);
    }

    @ParametersAreNonnullByDefault
    public static class DefaultEntityTab
    implements EntityTab {
        private static final long serialVersionUID = 1L;
        private final EntityTab _configDefault;

        public DefaultEntityTab(EntityTab configDefault) {
            this._configDefault = configDefault;
        }

        @CheckForNull
        public static final DefaultEntityTab createFrom(@Nullable EntityTab tab) {
            return tab == null ? null : new DefaultEntityTab(tab);
        }

        @Override
        public String getName() {
            return this._configDefault.getName() + "_DEFAULT";
        }

        @Override
        public <T> T accept(EntityTabVisitor<T> visitor) {
            return this._configDefault.accept(visitor);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof DefaultEntityTab && Objects.equal((Object)((DefaultEntityTab)obj)._configDefault, (Object)this._configDefault);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._configDefault});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("configDefault", (Object)this._configDefault).toString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ActiveChildEntityTypeVisitor
    extends DefaultEntityTabVisitor<Boolean> {
        private final ImmutableSet<EntityType> _activeEntityTypes;

        public ActiveChildEntityTypeVisitor(ImmutableSet<EntityType> activeEntityTypes) {
            this._activeEntityTypes = activeEntityTypes;
        }

        @Override
        public Boolean visitChildEntities(EntityType type) {
            return this._activeEntityTypes.contains((Object)type);
        }

        @Override
        protected Boolean visitDefault() {
            return Boolean.TRUE;
        }
    }
}

