/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityMemberUtil {
    public static boolean isMember(EntityMember member) {
        return EntityMemberRoles.isMember(member.getRoles());
    }

    public static boolean isUndecided(EntityMember member) {
        return EntityMemberRoles.isUndecided(member.getRoles());
    }

    public static boolean hasInvitation(EntityMember member) {
        return EntityMemberRoles.hasInvitation(member.getRoles());
    }

    public static boolean hasRejected(EntityMember member) {
        return EntityMemberRoles.hasRejected(member.getRoles());
    }

    public static boolean hasSentJoinRequest(EntityMember member) {
        return EntityMemberRoles.hasSentJoinRequest(member.getRoles());
    }

    public static boolean isAdmin(EntityMember member) {
        return EntityMemberRoles.isAdmin(member.getRoles());
    }

    public static boolean isCoAdmin(EntityMember member) {
        return EntityMemberRoles.isCoAdmin(member.getRoles());
    }

    public static boolean isAdminOrCoAdmin(EntityMember member) {
        return EntityMemberRoles.isAdminOrCoAdmin(member.getRoles());
    }

    public static boolean hasMemberRights(EntityMember member) {
        return EntityMemberRoles.hasMemberRights(member.getRoles());
    }

    public static boolean isShownAsMember(EntityMember member) {
        return EntityMemberRoles.isShownAsMember(member.getRoles());
    }

    public static boolean hasStatus(EntityMember member) {
        return EntityMemberRoles.hasStatus(member.getRoles());
    }

    public static boolean hasAnyRoleOf(EntityMember member, Set<EntityMemberRole> those) {
        return EntityMemberRoles.hasAnyRoleOf(member.getRoles(), those);
    }

    @Nonnull
    public static <I extends EntityMember> Iterable<I> filterByRoles(Iterable<I> entityMembers, ImmutableSet<EntityMemberRole> roles) {
        return Iterables.filter(entityMembers, EntityMemberUtil.composeRoleFilterPredicate(roles));
    }

    @Nonnull
    public static <I extends EntityMember> Iterable<I> filterByRoles(Iterable<I> entityMembers, EntityMemberRole ... roles) {
        return EntityMemberUtil.filterByRoles(entityMembers, (ImmutableSet<EntityMemberRole>)ImmutableSet.copyOf((Object[])roles));
    }

    @Nonnull
    public static Predicate<EntityMemberWithPerson> matchSearchQuery(String filter) {
        ImmutableSet searchWords = FluentIterable.from((Object[])filter.split(" ")).filter(Objects::nonNull).filter(Predicates.not(String::isEmpty)).transform(String::toLowerCase).toSet();
        return EntityMemberUtil.matchSearchWords((ImmutableSet<String>)searchWords);
    }

    @Nonnull
    private static Predicate<EntityMemberWithPerson> matchSearchWords(final ImmutableSet<String> searchWords) {
        return new NullIsFalsePredicate<EntityMemberWithPerson>(){

            @Override
            protected boolean applySafe(EntityMemberWithPerson input) {
                String firstName = input.getFirstName().toLowerCase();
                String lastName = input.getLastName().toLowerCase();
                String title = input.getTitle().toLowerCase();
                String additionalTitle = input.getAdditionalTitle().toLowerCase();
                for (String word : searchWords) {
                    if (firstName.contains(word) || lastName.contains(word) || title.contains(word) || additionalTitle.contains(word)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Nonnull
    public static Predicate<EntityMember> composeRoleFilterPredicate(EntityMemberRole ... roles) {
        return EntityMemberUtil.composeRoleFilterPredicate((Set<EntityMemberRole>)ImmutableSet.copyOf((Object[])roles));
    }

    @Nonnull
    public static Predicate<EntityMember> composeRoleFilterPredicate(Set<EntityMemberRole> roles) {
        return Predicates.compose(EntityMemberRoles.hasAnyRolePredicate(roles), EntityMember.GET_ROLES);
    }

    @Nonnull
    public static Predicate<EntityMember> composeEntityFilterPredicate(Set<EntityId> entityIds) {
        return Predicates.compose((Predicate)Predicates.in(entityIds), EntityMember.GET_ENTITY_ID);
    }

    @Nonnull
    public static Predicate<EntityMember> composePersonFilterPredicate(Set<PersonId> personIds) {
        return Predicates.compose((Predicate)Predicates.in(personIds), EntityMember.GET_PERSON_ID);
    }

    @Nonnull
    public static <I extends EntityMember> ImmutableSet<PersonId> transformToPersonIdSet(Iterable<I> entityMembers) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(entityMembers, EntityMember.GET_PERSON_ID));
    }

    @Nonnull
    public static <I extends EntityMember> ImmutableSet<EntityId> transformToEntityIdSet(Iterable<I> entityMembers) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(entityMembers, EntityMember.GET_ENTITY_ID));
    }

    @CheckForNull
    public static EntityMemberRole getAdminOrCoadmin(EntityMember member) {
        if (EntityMemberUtil.isAdmin(member)) {
            return EntityMemberRole.ADMIN;
        }
        if (EntityMemberUtil.isCoAdmin(member)) {
            return EntityMemberRole.CO_ADMIN;
        }
        return null;
    }
}

