/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewStatus;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public class DBEntityVersionReview {
    public static final Function<DBEntityVersionReview, PersonId> REVIEWER_TO_PERSON_ID = new Function<DBEntityVersionReview, PersonId>(){

        public PersonId apply(DBEntityVersionReview review) {
            return review != null ? review.getReviewerId() : null;
        }
    };
    public static final Function<DBEntityVersionReview, EntityVersionId> GET_ENTITY_VERSION_ID = new Function<DBEntityVersionReview, EntityVersionId>(){

        public EntityVersionId apply(DBEntityVersionReview review) {
            return review != null ? review.getEntityVersionId() : null;
        }
    };
    public static final Function<DBEntityVersionReview, ImmutableSet<PersonId>> GET_INVITER_AND_REVIEWER = new NullPermeableFunction<DBEntityVersionReview, ImmutableSet<PersonId>>(){

        @Override
        protected ImmutableSet<PersonId> applySafe(DBEntityVersionReview input) {
            return ImmutableSet.of((Object)input.getInviterId(), (Object)input.getReviewerId());
        }
    };
    private EntityVersionId _entityVersionId;
    private PersonId _reviewerId;
    private PersonId _inviterId;
    private EntityVersionReviewStatus _reviewStatus;
    private int _reviewOrder;

    @Nonnull
    public EntityVersionId getEntityVersionId() {
        return this._entityVersionId;
    }

    public void setEntityVersionId(@Nonnull EntityVersionId entityVersionId) {
        this._entityVersionId = entityVersionId;
    }

    @Nonnull
    public PersonId getReviewerId() {
        return this._reviewerId;
    }

    public void setReviewerId(@Nonnull PersonId reviewerId) {
        this._reviewerId = reviewerId;
    }

    @Nonnull
    public PersonId getInviterId() {
        return this._inviterId;
    }

    public void setInviterId(@Nonnull PersonId inviterId) {
        this._inviterId = inviterId;
    }

    @Nonnull
    public EntityVersionReviewStatus getReviewStatus() {
        return this._reviewStatus;
    }

    public void setReviewStatus(@Nonnull EntityVersionReviewStatus reviewStatus) {
        this._reviewStatus = reviewStatus;
    }

    public int getReviewOrder() {
        return this._reviewOrder;
    }

    public void setReviewOrder(int reviewOrder) {
        this._reviewOrder = reviewOrder;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityVersionId", (Object)this._entityVersionId).add("reviewerId", (Object)this._reviewerId).add("inviterId", (Object)this._inviterId).add("reviewStatus", (Object)this._reviewStatus).add("reviewOrder", this._reviewOrder).toString();
    }
}

