/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusImpl;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBEntityVersion
implements IEntityVersion {
    public static final Function<EntityVersion, DBEntityVersion> FROM_ENTITY_VERSION = new NullPermeableFunction<EntityVersion, DBEntityVersion>(){

        @Override
        protected DBEntityVersion applySafe(EntityVersion input) {
            return new DBEntityVersion(input);
        }
    };
    private EntityVersionId _id;
    private EntityId _entityId;
    private PersonId _authorId;
    private int _majorVersion;
    private int _minorVersion;
    private int _draftVersion;
    private String _changeMessage;
    private String _commentForReviewers;
    private String _declineMessage;
    private EntityStatus _status;
    private EntityVersionType _versionType;
    private EntityVersionType _targetType;
    private DateWithoutTimezone _releaseDate;
    private DateWithoutTimezone _expirationDate;
    private Date _createDate;
    private Date _modifyDate;

    public DBEntityVersion() {
    }

    public DBEntityVersion(@Nonnull EntityVersion origin) {
        this._id = origin.getId();
        this._entityId = origin.getEntityId();
        this._authorId = origin.getAuthorId();
        this._majorVersion = origin.getMajorVersion();
        this._minorVersion = origin.getMinorVersion();
        this._draftVersion = origin.getDraftVersion();
        this._changeMessage = origin.getChangeMessage();
        this._commentForReviewers = origin.getCommentForReviewers();
        this._declineMessage = origin.getDeclineMessage();
        this._status = (EntityStatus)EntityStatusImpl.TO_BUSINESS_MODEL.apply((Object)origin.getStatus());
        this._versionType = origin.getVersionType();
        this._targetType = origin.getTargetType();
        this._releaseDate = origin.getReleaseDate();
        this._expirationDate = origin.getExpirationDate();
        this._createDate = origin.getCreationDate();
        this._modifyDate = origin.getModificationDate();
    }

    @Override
    public EntityVersionId getId() {
        return this._id;
    }

    public void setId(@Nonnull EntityVersionId id) {
        this._id = id;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    public void setEntityId(@Nonnull EntityId entityId) {
        this._entityId = entityId;
    }

    @Override
    public int getMajorVersion() {
        return this._majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this._majorVersion = majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this._minorVersion = minorVersion;
    }

    @Override
    public EntityVersionType getVersionType() {
        return this._versionType;
    }

    public void setVersionType(@Nonnull EntityVersionType versionType) {
        this._versionType = versionType;
    }

    @Override
    public PersonId getAuthorId() {
        return this._authorId;
    }

    public void setAuthorId(@Nonnull PersonId personId) {
        this._authorId = personId;
    }

    @Override
    public EntityStatus getStatus() {
        return this._status;
    }

    public void setStatus(@Nonnull EntityStatus status) {
        this._status = status;
    }

    public void setDbStatus(@Nonnull DBEntityStatus status) {
        this._status = (EntityStatus)DBEntityStatus.TO_BUSINESS_STATUS.apply((Object)status);
    }

    public DBEntityStatus getDbStatus() {
        return (DBEntityStatus)DBEntityStatus.TO_DB_STATUS.apply((Object)this._status);
    }

    @Override
    public DateWithoutTimezone getExpirationDate() {
        return this._expirationDate;
    }

    public void setExpirationDate(@Nullable DateWithoutTimezone expirationDate) {
        this._expirationDate = expirationDate;
    }

    @Override
    public DateWithoutTimezone getReleaseDate() {
        return this._releaseDate;
    }

    public void setReleaseDate(@Nullable DateWithoutTimezone releaseDate) {
        this._releaseDate = releaseDate;
    }

    @Override
    public int getDraftVersion() {
        return this._draftVersion;
    }

    public void setDraftVersion(int draftVersion) {
        this._draftVersion = draftVersion;
    }

    public String toString() {
        return this.getVersionString();
    }

    @Override
    public String getChangeMessage() {
        return this._changeMessage;
    }

    public void setChangeMessage(@Nullable String changeMessage) {
        this._changeMessage = changeMessage;
    }

    @Override
    @Deprecated
    public EntityVersionType getTargetType() {
        return this._targetType;
    }

    @Deprecated
    public void setTargetType(@Nullable EntityVersionType targetType) {
        this._targetType = targetType;
    }

    @Override
    public String getCommentForReviewers() {
        return this._commentForReviewers;
    }

    public void setCommentForReviewers(@Nullable String commentForReviewers) {
        this._commentForReviewers = commentForReviewers;
    }

    @Override
    public String getDeclineMessage() {
        return this._declineMessage;
    }

    public void setDeclineMessage(@Nullable String declineMessage) {
        this._declineMessage = declineMessage;
    }

    @Override
    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion + "." + this._draftVersion;
    }

    @Override
    public DateWithoutTimezone getCreationDate() {
        return DateWithoutTimezone.clone(this._createDate);
    }

    @CheckForNull
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public void setCreateDate(@Nonnull Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    @Override
    public DateWithoutTimezone getModificationDate() {
        return DateWithoutTimezone.clone(this._modifyDate);
    }

    @CheckForNull
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(@Nonnull Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }
}

