/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class DBEntityLink
implements Serializable {
    public static final Predicate<DBEntityLink> INHERITS_MEMBERS = new Predicate<DBEntityLink>(){

        public boolean apply(@Nullable DBEntityLink input) {
            return input != null && input.isInheritsMembers();
        }
    };
    public static final Predicate<DBEntityLink> INHERITS_ADMIN = new Predicate<DBEntityLink>(){

        public boolean apply(@Nullable DBEntityLink input) {
            return input != null && input.isInheritsAdmins();
        }
    };
    public static final Function<DBEntityLink, DBEntityLink> CLONE_PARENT_SIDE = new NullPermeableFunction<DBEntityLink, DBEntityLink>(){

        @Override
        protected DBEntityLink applySafe(DBEntityLink input) {
            return new DBEntityLink(input.getLinkedEntityId(), input.isInheritsAdmins(), input.isInheritsMembers());
        }
    };
    private static final long serialVersionUID = 1L;
    private EntityId _entityId;
    private EntityId _linkedEntityId;
    private boolean _inheritsAdmins;
    private boolean _inheritsMembers;

    public DBEntityLink() {
    }

    public DBEntityLink(EntityId linkedEntityId, boolean inhertisAdmins, boolean inheritsMembers) {
        this._linkedEntityId = linkedEntityId;
        this._inheritsAdmins = inhertisAdmins;
        this._inheritsMembers = inheritsMembers;
    }

    public EntityId getEntityId() {
        return this._entityId;
    }

    public void setEntityId(EntityId entityId) {
        this._entityId = entityId;
    }

    public void setLinkedEntityId(EntityId linkedEntityId) {
        this._linkedEntityId = linkedEntityId;
    }

    public EntityId getLinkedEntityId() {
        return this._linkedEntityId;
    }

    public boolean isInheritsAdmins() {
        return this._inheritsAdmins;
    }

    public void setInheritsAdmins(boolean inheritsAdmins) {
        this._inheritsAdmins = inheritsAdmins;
    }

    public boolean isInheritsMembers() {
        return this._inheritsMembers;
    }

    public void setInheritsMembers(boolean inheritsMembers) {
        this._inheritsMembers = inheritsMembers;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._entityId, this._linkedEntityId, this._inheritsAdmins, this._inheritsMembers});
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DBEntityLink && this.isSameLinkedEntity((DBEntityLink)obj) && this.isSameChildEntity((DBEntityLink)obj) && this.hasSameInheritance((DBEntityLink)obj);
    }

    public boolean isSameLinkedEntity(DBEntityLink other) {
        return other != null && Objects.equal((Object)this._linkedEntityId, (Object)other._linkedEntityId);
    }

    public boolean isSameChildEntity(DBEntityLink other) {
        return other != null && Objects.equal((Object)this._entityId, (Object)other._entityId);
    }

    public boolean hasSameInheritance(DBEntityLink other) {
        return other != null && this._inheritsAdmins == other._inheritsAdmins && this._inheritsMembers == other._inheritsMembers;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("linkedEntityId", (Object)this._linkedEntityId).add("inheritsAdmins", this._inheritsAdmins).add("inheritsMembers", this._inheritsMembers).toString();
    }
}

