/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBEntityComponent {
    public static final Function<DBEntityComponent, ComponentType> TO_COMPONENT_TYPE = new Function<DBEntityComponent, ComponentType>(){

        public ComponentType apply(@Nullable DBEntityComponent input) {
            return input != null ? input.getComponentType() : null;
        }
    };
    public static final String PARENT_ID_PROPERTY = "parentId";
    public static final String COMPONENT_TYPE_PROPERTY = "componentType";
    private EntityId _parentId;
    private ComponentType _componentType;
    private ComponentPosition _position;
    private int _order;
    private boolean _visible;
    private List<String> _openFor = Lists.newLinkedList();
    private List<AuthorityModel> _availableRolesToOpenFor;
    private String _customizedTitle;

    @Deprecated
    public DBEntityComponent() {
    }

    public DBEntityComponent(EntityId parentId, ComponentType componentType, ComponentPosition position, int order, boolean visible, @Nonnull Iterable<String> openFor, List<AuthorityModel> availableRolesToOpenFor, @Nullable String customizedTitle) {
        this._parentId = parentId;
        this._componentType = componentType;
        this._position = position;
        this._order = order;
        this._visible = visible;
        this._openFor = Lists.newLinkedList(openFor);
        this._availableRolesToOpenFor = availableRolesToOpenFor;
        this._customizedTitle = customizedTitle;
    }

    @Deprecated
    @Nonnull
    public List<String> getOpenFor() {
        return this._openFor;
    }

    @Deprecated
    public void setOpenFor(@Nullable List<String> openFor) {
        this._openFor = openFor != null ? openFor : Lists.newLinkedList();
    }

    public List<AuthorityModel> getAvailableRolesToOpenFor() {
        return this._availableRolesToOpenFor;
    }

    @Nonnull
    public ImmutableSet<AuthorityModel> getAvailableRolesToOpenForAsSet() {
        return this._availableRolesToOpenFor == null ? ImmutableSet.of() : ImmutableSet.copyOf(this._availableRolesToOpenFor);
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public EntityId getParentId() {
        return this._parentId;
    }

    public void setParentId(EntityId globalId) {
        this._parentId = globalId;
    }

    public ComponentPosition getPosition() {
        return this._position;
    }

    public void setPosition(ComponentPosition position) {
        this._position = position;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public ComponentType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(ComponentType componentType) {
        this._componentType = componentType;
    }

    @Nonnull
    public ImmutableSet<String> getOpenForAuthNames() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this._openFor, (Predicate)Predicates.notNull()));
    }

    @CheckForNull
    public String getCustomizedTitle() {
        return this._customizedTitle;
    }

    public void setCustomizedTitle(@Nullable String customizedTitle) {
        this._customizedTitle = customizedTitle;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(PARENT_ID_PROPERTY, (Object)this._parentId).add(COMPONENT_TYPE_PROPERTY, (Object)this._componentType).add("position", (Object)this._position).add("order", this._order).add("visible", this._visible).add("openFor", this._openFor).toString();
    }
}

