/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ReleaseProcessStatus {
    DRAFT{

        @Override
        public boolean isDefault() {
            return true;
        }
    }
    ,
    IN_REVIEW,
    DECLINED,
    RELEASED,
    PUBLISHED{

        @Override
        public boolean isPublished() {
            return true;
        }
    }
    ,
    ARCHIVED{

        @Override
        public boolean isPublished() {
            return true;
        }

        @Override
        public boolean isArchived() {
            return true;
        }
    };

    public static final ImmutableSet<String> ALL_NAMES;

    @Nonnull
    public String getName() {
        return this.name();
    }

    @CheckForNull
    public static ReleaseProcessStatus fromStringIfExists(@Nonnull String name) {
        for (ReleaseProcessStatus status : ReleaseProcessStatus.values()) {
            if (!status.name().equals(name)) continue;
            return status;
        }
        return null;
    }

    @CheckForNull
    public static ReleaseProcessStatus fromStatusIfExists(@Nonnull EntityStatus dynamicStatus) {
        for (ReleaseProcessStatus status : ReleaseProcessStatus.values()) {
            if (!status.name().equals(dynamicStatus.getName())) continue;
            return status;
        }
        return null;
    }

    public boolean isArchived() {
        return false;
    }

    public boolean isPublished() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean equalsEntityStatus(@Nullable EntityStatus s) {
        return s != null && s.hasName(this.getName());
    }

    static {
        ALL_NAMES = FluentIterable.from((Object[])ReleaseProcessStatus.values()).transform(ReleaseProcessStatus::getName).toSet();
    }
}

