/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.common.shared.model.Id;
import de.justsoftware.onx.container.shared.model.AbstractCreateGlobalIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.container.shared.model.PseudoEntityItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.drive.shared.model.DriveTempId;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.wiki.shared.model.ArticleId;
import de.justsoftware.onx.wiki.shared.model.ChapterId;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import de.justsoftware.onx.workstream.shared.model.FeedId;
import de.justsoftware.polls.model.pollid.PollId;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface ItemId
extends Id {
    @Nonnull
    public ItemType getType();

    @Nonnull
    public <T> T accept(ItemIdVisitor<T> var1);

    @Nonnull
    public String asString();

    @Nonnull
    @Deprecated
    public String getSqlString();

    @CheckForNull
    public static ItemId parse(@Nullable String s) {
        ItemType itemType;
        if (s == null) {
            return null;
        }
        String t = s.trim();
        int comma = t.indexOf(44);
        if (comma < 0) {
            throw new IdParseException("Input '" + s + "' has wrong format. Must be of format 'TYPE,ID'");
        }
        String rest = t.substring(comma + 1);
        try {
            itemType = ItemType.valueOf(t.substring(0, comma));
        }
        catch (IllegalArgumentException ex) {
            throw new IdParseException("Input '" + s + "' denotes unknown ID type.");
        }
        return ItemId.create(itemType, rest);
    }

    @CheckForNull
    public static ItemId parseSafe(@Nullable String s) {
        try {
            return ItemId.parse(s);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Nonnull
    public static ItemId create(final ItemType type, final String id) {
        return type.accept(new AbstractCreateGlobalIdVisitor(){

            @Override
            protected long longId() {
                try {
                    return Long.parseLong(id);
                }
                catch (NumberFormatException ex) {
                    throw new IdParseException("Input '" + type + "," + id + "' has wrong format. Must be of format 'TYPE,ID', where ID is a 64-bit two's complement integer.");
                }
            }

            @Override
            public PseudoEntityItemId visitPseudoEntity() {
                return new PseudoEntityItemId(EntityType.valueOf(id));
            }

            @Override
            public ItemId visitConversation() {
                return new ConversationId(UUID.fromString(id));
            }

            @Override
            public ItemId visitChatMessage() {
                return new ChatMessageId(UUID.fromString(id));
            }

            @Override
            public ItemId visitChat() {
                return new ChatId(UUID.fromString(id));
            }

            @Override
            public DriveDocumentId visitDriveDocument() {
                return new DriveDocumentId(id);
            }

            @Override
            public DriveTempId visitDriveTempDocument() {
                return new DriveTempId(id);
            }

            @Override
            public ItemId visitTask() {
                return new TaskId(UUID.fromString(id));
            }

            @Override
            public ItemId visitTaskList() {
                return new TaskListId(UUID.fromString(id));
            }

            @Override
            public ItemId visitDriveShare() {
                return new DriveShareId(UUID.fromString(id));
            }

            @Override
            public ItemId visitFeed() {
                return new FeedId(new AppId(id));
            }

            @Override
            public ItemId visitTenant() {
                return new TenantId(UUID.fromString(id));
            }

            @Override
            public ItemId visitWiki() {
                return new WikiId(id);
            }

            @Override
            public ItemId visitChapter() {
                return new ChapterId(id);
            }

            @Override
            public ItemId visitArticle() {
                return new ArticleId(id);
            }

            @Override
            public ItemId visitNewsPost() {
                return new NewsPostId(id);
            }

            @Override
            public ItemId visitPoll() {
                return new PollId(UUID.fromString(id));
            }

            @Override
            public ItemId visitNewsChannel() {
                return new NewsChannelId(id);
            }
        });
    }
}

