/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.validation.constraint.AcceptEntityVersionReviewConstraint;
import de.justsoftware.onx.container.shared.model.validation.constraint.DeclineEntityVersionReviewConstraint;
import de.justsoftware.onx.container.shared.model.validation.constraint.DefaultEntityVersionReviewConstraint;
import de.justsoftware.onx.container.shared.model.validation.group.AcceptVersionValidationGroup;
import de.justsoftware.onx.container.shared.model.validation.group.DeclineVersionValidationGroup;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserWithEntityVersionReviewStatusModel;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.groups.Default;

@AcceptEntityVersionReviewConstraint(groups={AcceptVersionValidationGroup.class})
@DeclineEntityVersionReviewConstraint(groups={DeclineVersionValidationGroup.class})
@DefaultEntityVersionReviewConstraint(groups={Default.class})
public class EntityVersionReviewData
implements Serializable {
    private static final long serialVersionUID = 2L;
    private EntityVersionId _entityVersionId;
    private PersonTeaserModel _inviter;
    private EntityInfo _toReview;
    private ImmutableList<PersonTeaserWithEntityVersionReviewStatusModel> _reviewer;
    private DateWithoutTimezone _releaseDate;
    private DateWithoutTimezone _expirationDate;
    private DateWithoutTimezone _expirationDateLastPublishedVersion;
    private String _changeMessage;
    private String _commentForReviewer;
    private String _declineMessage;
    private EntityVersionType _versionType;
    private EntityStatusClientModel _entityStatus;
    private boolean _mayDecline;
    private boolean _mayAccept;
    private boolean _mayReview;
    private boolean _releaseDateMandatory;
    private boolean _expirationDateMandatory;
    private int _maxDaysAsActiveVersion;

    @Deprecated
    public EntityVersionReviewData() {
    }

    public EntityVersionReviewData(@Nonnull EntityVersionId entityVersionId, @Nonnull EntityStatusClientModel entityStatus, @Nonnull PersonTeaserModel inviter, @Nonnull EntityInfo toReview, @Nonnull ImmutableList<PersonTeaserWithEntityVersionReviewStatusModel> reviewer, @Nullable DateWithoutTimezone releaseDate, @Nullable DateWithoutTimezone expirationDate, @Nullable DateWithoutTimezone expirationDateLastPublishedVersion, @Nonnull String changeMessage, @Nullable String commentForReviewer, @Nullable String declineMessage, @Nonnull EntityVersionType versionType, boolean mayDecline, boolean mayAccept, boolean mayReview, boolean releaseDateMandatory, boolean expirationDateMandatory, int maxDaysAsActiveVersion) {
        this._entityVersionId = entityVersionId;
        this._entityStatus = entityStatus;
        this._inviter = inviter;
        this._toReview = toReview;
        this._reviewer = reviewer;
        this._versionType = versionType;
        this._releaseDate = DateWithoutTimezone.clone(releaseDate);
        this._expirationDate = DateWithoutTimezone.clone(expirationDate);
        this._expirationDateLastPublishedVersion = DateWithoutTimezone.clone(expirationDateLastPublishedVersion);
        this._changeMessage = changeMessage;
        this._commentForReviewer = commentForReviewer;
        this._declineMessage = declineMessage;
        this._mayAccept = mayAccept;
        this._mayDecline = mayDecline;
        this._mayReview = mayReview;
        this._releaseDateMandatory = releaseDateMandatory;
        this._expirationDateMandatory = expirationDateMandatory;
        this._maxDaysAsActiveVersion = maxDaysAsActiveVersion;
    }

    @Nonnull
    public EntityVersionId getEntityVersionId() {
        return this._entityVersionId;
    }

    @Nonnull
    public PersonTeaserModel getInviter() {
        return this._inviter;
    }

    @Nonnull
    public EntityInfo getToReview() {
        return this._toReview;
    }

    @Nonnull
    public ImmutableList<PersonTeaserWithEntityVersionReviewStatusModel> getReviewer() {
        return this._reviewer;
    }

    public void setReleaseDate(@Nullable DateWithoutTimezone releaseDate) {
        this._releaseDate = DateWithoutTimezone.clone(releaseDate);
    }

    @CheckForNull
    public DateWithoutTimezone getReleaseDate() {
        return DateWithoutTimezone.clone(this._releaseDate);
    }

    public void setExpirationDate(@Nullable DateWithoutTimezone expirationDate) {
        this._expirationDate = DateWithoutTimezone.clone(expirationDate);
    }

    @CheckForNull
    public DateWithoutTimezone getExpirationDate() {
        return DateWithoutTimezone.clone(this._expirationDate);
    }

    @CheckForNull
    public DateWithoutTimezone getExpirationDateLastPublishedVersion() {
        return this._expirationDateLastPublishedVersion;
    }

    @Nonnull
    public String getChangeMessage() {
        return this._changeMessage;
    }

    @CheckForNull
    public String getCommentForReviewer() {
        return this._commentForReviewer;
    }

    public void setDeclineMessage(@Nullable String declineMessage) {
        this._declineMessage = declineMessage;
    }

    @CheckForNull
    public String getDeclineMessage() {
        return this._declineMessage;
    }

    @Nonnull
    public EntityVersionType getVersionType() {
        return this._versionType;
    }

    @Nonnull
    public EntityStatusClientModel getVersionStatus() {
        return this._entityStatus;
    }

    public boolean mayAccept() {
        return this._mayAccept;
    }

    public boolean mayDecline() {
        return this._mayDecline;
    }

    public boolean mayReview() {
        return this._mayReview;
    }

    public boolean getReleaseDateMandatory() {
        return this._releaseDateMandatory;
    }

    public boolean getExpirationDateMandatory() {
        return this._expirationDateMandatory;
    }

    public int getMaxDaysAsActiveVersion() {
        return this._maxDaysAsActiveVersion;
    }

    @Nonnull
    public EntityVersionReviewData getValidationModel(@Nullable DateWithoutTimezone releaseDate, @Nullable DateWithoutTimezone expirationDate, @Nullable String declineMessage) {
        return new EntityVersionReviewData(this.getEntityVersionId(), this.getVersionStatus(), this.getInviter(), this.getToReview(), this.getReviewer(), releaseDate, expirationDate, this.getExpirationDateLastPublishedVersion(), this.getChangeMessage(), this.getCommentForReviewer(), declineMessage, this.getVersionType(), this.mayDecline(), this.mayAccept(), this.mayReview(), this.getReleaseDateMandatory(), this.getExpirationDateMandatory(), this.getMaxDaysAsActiveVersion());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityVersionId", (Object)this._entityVersionId).add("inviter", (Object)this._inviter).add("toReview", (Object)this._toReview).add("reviewer", this._reviewer == null ? null : Integer.valueOf(this._reviewer.size())).add("releaseDate", (Object)this._releaseDate).add("expirationDate", (Object)this._expirationDate).add("expirationDateLastPublishedVersion", (Object)this._expirationDateLastPublishedVersion).add("changeMessage", (Object)this._changeMessage).add("commentForReviewer", (Object)this._commentForReviewer).add("declineMessage", (Object)this._declineMessage).add("versionType", (Object)this._versionType).add("entityStatus", (Object)this._entityStatus).add("mayDecline", this._mayDecline).add("mayAccept", this._mayAccept).add("mayReview", this._mayReview).add("releaseDateMandatory", this._releaseDateMandatory).add("expirationDateMandatory", this._expirationDateMandatory).add("maxDaysAsActiveVersion", this._maxDaysAsActiveVersion).toString();
    }
}

