/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.ItemType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityVersionId
extends GlobalId
implements Comparable<EntityVersionId> {
    private static final long serialVersionUID = 1L;

    public EntityVersionId(long id) {
        super(id);
    }

    @Deprecated
    public EntityVersionId() {
    }

    @CheckForNull
    public static EntityVersionId parse(@Nullable String s) {
        if (s == null) {
            return null;
        }
        try {
            GlobalId globalId = GlobalId.parse(s);
            if (globalId instanceof EntityVersionId) {
                return (EntityVersionId)globalId;
            }
        }
        catch (IdParseException idParseException) {
            // empty catch block
        }
        return null;
    }

    public boolean before(@Nonnull EntityVersionId other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public int compareTo(EntityVersionId o) {
        if (o == null) {
            return 1;
        }
        return (int)(this.getId() - o.getId());
    }

    @Override
    public ItemType getType() {
        return ItemType.ENTITY_VERSION;
    }

    @Override
    public <T> T accept(ItemIdVisitor<T> v) {
        return v.visit(this);
    }
}

