/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public final class EntityMemberWithPerson
implements EntityMember {
    public static final Function<EntityMemberWithPerson, String> LASTNAME = new Function<EntityMemberWithPerson, String>(){

        public String apply(EntityMemberWithPerson input) {
            return input == null ? null : input.getLastName();
        }
    };
    public static final Predicate<EntityMemberWithPerson> IS_ACTIVE = new Predicate<EntityMemberWithPerson>(){

        public boolean apply(EntityMemberWithPerson input) {
            return input != null && input.isActive();
        }
    };
    private static final long serialVersionUID = 1L;
    private PersonId _personId;
    private EntityId _entityId;
    private boolean _active;
    private boolean _hasImage;
    private ImmutableSet<EntityMemberRole> _roles;
    private EntityMember.InheritanceType _inheritanceType;
    private String _firstName;
    private String _lastName;
    private String _title;
    private String _additionalTitle;

    @Deprecated
    public EntityMemberWithPerson() {
    }

    @ParametersAreNonnullByDefault
    public EntityMemberWithPerson(PersonId personId, EntityId entityId, Iterable<EntityMemberRole> memberRoles, boolean active, boolean hasImage, EntityMember.InheritanceType inheritanceType, String firstname, String lastname, String title, String additionalTitle) {
        this._personId = personId;
        this._entityId = entityId;
        this._active = active;
        this._hasImage = hasImage;
        this._title = title;
        this._additionalTitle = additionalTitle;
        this._roles = EntityMemberRoles.filter(memberRoles);
        this._inheritanceType = inheritanceType;
        this._firstName = firstname;
        this._lastName = lastname;
    }

    @Override
    public PersonId getPersonId() {
        return this._personId;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Override
    public ImmutableSet<EntityMemberRole> getRoles() {
        return this._roles;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isHasImage() {
        return this._hasImage;
    }

    @Nonnull
    public String getFirstName() {
        return this._firstName;
    }

    @Nonnull
    public String getLastName() {
        return this._lastName;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("personId", (Object)this._personId).add("entityId", (Object)this._entityId).add("roles", this._roles).add("active", this._active).add("hasImage", this._hasImage).add("inheritanceType", (Object)this._inheritanceType).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).toString();
    }

    @Override
    public EntityMember.InheritanceType getInheritanceType() {
        return this._inheritanceType;
    }

    public boolean isActiveMember() {
        return this._active && !Sets.intersection(this._roles, EntityMemberRoles.VISIBLE_MEMBER).isEmpty();
    }
}

