/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.container.shared.model.AdminstrationWorkflowRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflowRole;
import de.justsoftware.onx.container.shared.model.EventWorkflowRole;
import de.justsoftware.onx.container.shared.model.MemberWorkflowRole;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import javax.annotation.Nonnull;

public final class EntityMemberRole
implements Comparable<EntityMemberRole>,
RoleOrInheritedRole {
    public static final Function<EntityMemberRole, String> TO_NAME_FUNCTION = new Function<EntityMemberRole, String>(){

        public String apply(EntityMemberRole input) {
            return input != null ? input.getName() : null;
        }
    };
    private static final ValueOfMap<String, EntityMemberRole> BY_NAME = new ValueOfMap<String, EntityMemberRole>(){
        {
            this.putAll(AdminstrationWorkflowRole.values());
            this.putAll(MemberWorkflowRole.values());
            this.putAll(EventWorkflowRole.values());
        }

        @Override
        protected EntityMemberRole create(String name) {
            DynamicWorkflowRole acceptor = new DynamicWorkflowRole(name, 0);
            return new EntityMemberRole(acceptor);
        }

        private void putAll(@Nonnull EntityMemberWorkflowRole[] values) {
            for (EntityMemberWorkflowRole acceptor : values) {
                EntityMemberRole role = new EntityMemberRole(acceptor);
                this.put(role.getName(), role);
            }
        }
    };
    public static final EntityMemberRole ADMIN = EntityMemberRole.valueOf(AdminstrationWorkflowRole.ADMIN);
    public static final EntityMemberRole CO_ADMIN = EntityMemberRole.valueOf(AdminstrationWorkflowRole.CO_ADMIN);
    public static final EntityMemberRole MEMBER = EntityMemberRole.valueOf(MemberWorkflowRole.MEMBER);
    public static final EntityMemberRole HAS_REJECTED = EntityMemberRole.valueOf(MemberWorkflowRole.HAS_REJECTED);
    public static final EntityMemberRole HAS_SENT_JOINREQUEST = EntityMemberRole.valueOf(MemberWorkflowRole.HAS_SENT_JOINREQUEST);
    public static final EntityMemberRole HAS_INVITATION = EntityMemberRole.valueOf(MemberWorkflowRole.HAS_INVITATION);
    public static final EntityMemberRole IS_UNDECIDED = EntityMemberRole.valueOf(MemberWorkflowRole.IS_UNDECIDED);
    public static final EntityMemberRole EVENT_IS_ATTENDING = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_IS_ATTENDING);
    public static final EntityMemberRole EVENT_IS_NOT_ATTENDING = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_IS_NOT_ATTENDING);
    public static final EntityMemberRole EVENT_IS_MAYBE_ATTENDING = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_IS_MAYBE_ATTENDING);
    public static final EntityMemberRole EVENT_IS_ON_WAITINGLIST = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_IS_ON_WAITINGLIST);
    public static final EntityMemberRole EVENT_IS_INVITED = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_IS_INVITED);
    public static final EntityMemberRole EVENT_HAS_REJECTED_INVITATION = EntityMemberRole.valueOf(EventWorkflowRole.EVENT_HAS_REJECTED_INVITATION);
    private static final long serialVersionUID = 2L;
    private final EntityMemberWorkflowRole _acceptor;

    private EntityMemberRole(@Nonnull EntityMemberWorkflowRole acceptor) {
        this._acceptor = acceptor;
    }

    @Nonnull
    public String getName() {
        return this._acceptor.getName();
    }

    public int getOrder() {
        return this._acceptor.getOrder();
    }

    @Nonnull
    public <T> T accept(@Nonnull Visitor<T> visitor) {
        return this._acceptor.accept(visitor);
    }

    @Override
    public <T> T accept(RoleOrInheritedRole.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName()});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof EntityMemberRole && Objects.equal((Object)this.getName(), (Object)((EntityMemberRole)obj).getName());
    }

    @Nonnull
    public static EntityMemberRole valueOf(@Nonnull EntityMemberWorkflowRole role) {
        return EntityMemberRole.valueOf(role.getName());
    }

    @Nonnull
    public static EntityMemberRole valueOf(@Nonnull String rolename) {
        return BY_NAME.get(rolename);
    }

    @Override
    public int compareTo(EntityMemberRole o) {
        return this.getOrder() == o.getOrder() ? this.getName().compareTo(o.getName()) : this.getOrder() - o.getOrder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).toString();
    }

    private static class DynamicWorkflowRole
    implements EntityMemberWorkflowRole {
        private final String _name;
        private final EntityMemberRole _role;
        private final int _order;

        DynamicWorkflowRole(@Nonnull String name, int order) {
            this._name = name;
            this._role = new EntityMemberRole(this);
            this._order = order;
        }

        @Override
        public int getOrder() {
            return this._order;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDynamicRole(this._role);
        }

        @Override
        public String getName() {
            return this._name;
        }
    }

    public static abstract class DefaultVisitor<R>
    implements Visitor<R>,
    Function<EntityMemberRole, R> {
        @Override
        public R visitMember() {
            return this.getDefault();
        }

        @Override
        public R visitRejected() {
            return this.getDefault();
        }

        @Override
        public R visitHasSentJoinRequest() {
            return this.getDefault();
        }

        @Override
        public R visitHasInvitation() {
            return this.getDefault();
        }

        @Override
        public R visitIsUndecided() {
            return this.getDefault();
        }

        @Override
        public R visitCoAdmin() {
            return this.getDefault();
        }

        @Override
        public R visitAdmin() {
            return this.getDefault();
        }

        @Override
        public R visitIsAttendingTheEvent() {
            return this.getDefault();
        }

        @Override
        public R visitIsNotAttendingTheEvent() {
            return this.getDefault();
        }

        @Override
        public R visitIsMaybeAttendingTheEvent() {
            return this.getDefault();
        }

        @Override
        public R visitIsOnWaitinglistForEvent() {
            return this.getDefault();
        }

        @Override
        public R visitIsInvitedToEvent() {
            return this.getDefault();
        }

        @Override
        public R visitHasRejectedTheEventInvitation() {
            return this.getDefault();
        }

        @Override
        public R visitDynamicRole(EntityMemberRole role) {
            return this.getDefault();
        }

        @Nonnull
        protected abstract R getDefault();

        public R apply(EntityMemberRole input) {
            return input != null ? (R)input.accept(this) : null;
        }
    }

    public static interface EventWorkflowVisitor<E> {
        @Nonnull
        public E visitIsAttendingTheEvent();

        @Nonnull
        public E visitIsNotAttendingTheEvent();

        @Nonnull
        public E visitIsMaybeAttendingTheEvent();

        @Nonnull
        public E visitIsOnWaitinglistForEvent();

        @Nonnull
        public E visitIsInvitedToEvent();

        @Nonnull
        public E visitHasRejectedTheEventInvitation();
    }

    public static interface MemberWorkflowVisitor<E> {
        @Nonnull
        public E visitMember();

        @Nonnull
        public E visitRejected();

        @Nonnull
        public E visitHasSentJoinRequest();

        @Nonnull
        public E visitHasInvitation();

        @Nonnull
        public E visitIsUndecided();
    }

    public static interface AdministrationWorkflowVisitor<E> {
        @Nonnull
        public E visitCoAdmin();

        @Nonnull
        public E visitAdmin();
    }

    public static interface Visitor<E>
    extends MemberWorkflowVisitor<E>,
    AdministrationWorkflowVisitor<E>,
    EventWorkflowVisitor<E> {
        @Nonnull
        public E visitDynamicRole(@Nonnull EntityMemberRole var1);
    }
}

