/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.io.Serializable;
import javax.annotation.Nonnull;

public interface EntityMember
extends Serializable {
    public static final Function<EntityMember, EntityId> GET_ENTITY_ID = new Function<EntityMember, EntityId>(){

        public EntityId apply(EntityMember input) {
            return input != null ? input.getEntityId() : null;
        }
    };
    public static final Function<EntityMember, PersonId> GET_PERSON_ID = new Function<EntityMember, PersonId>(){

        public PersonId apply(EntityMember input) {
            return input != null ? input.getPersonId() : null;
        }
    };
    public static final Function<EntityMember, ImmutableSet<EntityMemberRole>> GET_ROLES = new Function<EntityMember, ImmutableSet<EntityMemberRole>>(){

        public ImmutableSet<EntityMemberRole> apply(EntityMember input) {
            return input != null ? input.getRoles() : null;
        }
    };
    public static final Function<EntityMember, InheritanceType> GET_INHERITANCE_TYPE = new Function<EntityMember, InheritanceType>(){

        public InheritanceType apply(EntityMember input) {
            return input != null ? input.getInheritanceType() : null;
        }
    };
    public static final Predicate<EntityMember> INHERITED_MEMBER = new NullIsFalsePredicate<EntityMember>(){

        @Override
        protected boolean applySafe(EntityMember input) {
            return InheritanceType.INHERITED.equals((Object)input.getInheritanceType());
        }
    };
    public static final Predicate<EntityMember> DIRECT_MEMBER = new NullIsFalsePredicate<EntityMember>(){

        @Override
        protected boolean applySafe(EntityMember input) {
            return InheritanceType.NONE.equals((Object)input.getInheritanceType());
        }
    };

    @Nonnull
    public EntityId getEntityId();

    @Nonnull
    public PersonId getPersonId();

    @Nonnull
    public ImmutableSet<EntityMemberRole> getRoles();

    @Nonnull
    public InheritanceType getInheritanceType();

    public static enum InheritanceType {
        NONE,
        INHERITED;

    }
}

