/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.shared.model.Teaser;
import de.justsoftware.onx.container.shared.model.Appointment;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.WithMemberWorkflow;
import de.justsoftware.onx.searchnew.shared.model.SearchResultEntry;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface EntityInfo
extends Teaser<EntityId, EntityType>,
SearchResultEntry,
Appointment,
WithMemberWorkflow {
    public static final Predicate<EntityInfo> IS_VISIBLE = new NullIsFalsePredicate<EntityInfo>(){

        @Override
        protected boolean applySafe(EntityInfo input) {
            return input.isVisible();
        }
    };
    public static final Comparator<EntityInfo> NAME_COMPARATOR = new Comparator<EntityInfo>(){

        @Override
        public int compare(EntityInfo o1, EntityInfo o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (!o1.isVisible()) {
                return 1;
            }
            if (!o2.isVisible()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    public static final Function<EntityInfo, String> GET_ICON = new NullPermeableFunction<EntityInfo, String>(){

        @Override
        protected String applySafe(EntityInfo input) {
            return input.getIcon();
        }
    };
    public static final Function<EntityInfo, EntityType> GET_TYPE = new NullPermeableFunction<EntityInfo, EntityType>(){

        @Override
        protected EntityType applySafe(EntityInfo input) {
            return (EntityType)input.getType();
        }
    };
    public static final Function<? super EntityInfo, EntityId> GET_ID = new NullPermeableFunction<EntityInfo, EntityId>(){

        @Override
        protected EntityId applySafe(EntityInfo input) {
            return (EntityId)input.getId();
        }
    };

    @CheckForNull
    public String getSlideshowImage();

    public String getIcon();

    public boolean isVisible();

    @Nonnull
    public CoreApp getApp();

    @Nonnull
    public TenantId getTenantId();
}

