/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityExtendedData
implements Serializable {
    private static final long serialVersionUID = 7121130861109341977L;
    private EntityId _entityId;
    private List<DBEntityLinkedEntityPrivacy> _privacyData;
    private List<String> _invitingRule;
    private List<String> _newsletterRule;

    @Deprecated
    public EntityExtendedData() {
    }

    public EntityExtendedData(@Nonnull EntityId entityId, @Nonnull List<DBEntityLinkedEntityPrivacy> privacyData, @Nullable List<String> invitingRule, @Nullable List<String> newsletterRule) {
        this._entityId = entityId;
        this._privacyData = privacyData;
        this._invitingRule = invitingRule;
        this._newsletterRule = newsletterRule;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public List<DBEntityLinkedEntityPrivacy> getPrivacyData() {
        return ImmutableList.copyOf(this._privacyData);
    }

    @CheckForNull
    public List<String> getInvitingRule() {
        return this._invitingRule;
    }

    @CheckForNull
    public List<String> getNewsletterRule() {
        return this._newsletterRule;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("privacyData", this._privacyData == null ? null : Integer.valueOf(this._privacyData.size())).add("invitingRule", this._invitingRule == null ? null : Integer.valueOf(this._invitingRule.size())).add("newsletterRule", this._newsletterRule == null ? null : Integer.valueOf(this._newsletterRule.size())).toString();
    }
}

