/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentWidth;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentPositionConfig
implements Serializable {
    public static final Predicate<ComponentPositionConfig> IS_VISIBLE = new Predicate<ComponentPositionConfig>(){

        public boolean apply(ComponentPositionConfig input) {
            return input != null && input.isVisible();
        }
    };
    public static final Function<ComponentPositionConfig, ComponentPosition> POSITION_FUNCTION = new Function<ComponentPositionConfig, ComponentPosition>(){

        public ComponentPosition apply(ComponentPositionConfig input) {
            return input != null ? input.getPosition() : null;
        }
    };
    public static final Function<ComponentPositionConfig, Integer> ORDER_FUNCTION = new Function<ComponentPositionConfig, Integer>(){

        public Integer apply(ComponentPositionConfig input) {
            return input != null ? Integer.valueOf(input.getOrder()) : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private ComponentType _type;
    private ComponentPosition _position;
    private int _order;
    private boolean _visible;
    private String _customizedTitle;
    private ImmutableSet<String> _openFor;
    private ImmutableSet<AuthorityModel> _availableRolesToOpenFor;

    @Deprecated
    public ComponentPositionConfig() {
    }

    public ComponentPositionConfig(@Nonnull ComponentType type, @Nonnull ComponentPosition position, int order, boolean visible, @Nonnull ImmutableSet<String> openFor, @Nonnull ImmutableSet<AuthorityModel> availableRolesToOpenFor, @Nullable String customizedTitle) {
        this._type = type;
        this._position = position;
        this._order = order;
        this._visible = visible;
        this._openFor = openFor;
        this._customizedTitle = customizedTitle;
        this._availableRolesToOpenFor = availableRolesToOpenFor;
    }

    public ComponentPositionConfig(DBEntityComponent component) {
        this._type = component.getComponentType();
        this._position = component.getPosition();
        this._order = component.getOrder();
        this._visible = component.isVisible();
        this._openFor = component.getOpenForAuthNames();
        this._customizedTitle = component.getCustomizedTitle();
        this._availableRolesToOpenFor = component.getAvailableRolesToOpenForAsSet();
    }

    @Nonnull
    public ComponentType getType() {
        return this._type;
    }

    @Nonnull
    public ComponentPosition getPosition() {
        return this._position;
    }

    @Nonnull
    public ComponentWidth getWidth() {
        switch (this._position) {
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return ComponentWidth.NARROW;
            }
            case CENTER: {
                return ComponentWidth.WIDE;
            }
        }
        return ComponentWidth.MEDIUM;
    }

    public int getOrder() {
        return this._order;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Nonnull
    public ImmutableSet<String> getOpenFor() {
        return this._openFor;
    }

    @Nonnull
    public ImmutableSet<AuthorityModel> getAvailableRolesToOpenFor() {
        return this._availableRolesToOpenFor;
    }

    @CheckForNull
    public String getCustomizedTitle() {
        return this._customizedTitle;
    }

    public void setCustomizedTitle(@Nullable String customizedTitle) {
        this._customizedTitle = customizedTitle;
    }

    @Nonnull
    public static Predicate<ComponentPositionConfig> hasType(final @Nonnull ComponentType type) {
        return new Predicate<ComponentPositionConfig>(){

            public boolean apply(ComponentPositionConfig input) {
                return input != null && input.getType() == type;
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("position", (Object)this._position).add("order", this._order).add("visible", this._visible).add("customizedTitle", (Object)this._customizedTitle).add("openFor", this._openFor == null ? null : Integer.valueOf(this._openFor.size())).add("availableRolesToOpenFor", this._availableRolesToOpenFor == null ? null : Integer.valueOf(this._availableRolesToOpenFor.size())).toString();
    }
}

