/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.server.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityRecommendation {
    private final EntityId _entityId;
    private final PersonId _personId;
    private final PersonId _recommenderId;
    private final String _recommendationMessage;
    private final Date _recommendationDate;

    public EntityRecommendation(@Nonnull EntityId entityId, @Nonnull PersonId personId, @Nonnull PersonId recommenderId, @Nonnull String recommendationMessage, @Nonnull Date recommendationDate) {
        this._entityId = entityId;
        this._personId = personId;
        this._recommenderId = recommenderId;
        this._recommendationMessage = recommendationMessage;
        this._recommendationDate = Dates.clone(recommendationDate);
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    public PersonId getRecommenderId() {
        return this._recommenderId;
    }

    @Nonnull
    public String getRecommendationMessage() {
        return this._recommendationMessage;
    }

    @Nonnull
    public Date getRecommendationDate() {
        return Dates.clone(this._recommendationDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("personId", (Object)this._personId).add("recommenderId", (Object)this._recommenderId).add("recommendationMessage", (Object)this._recommendationMessage).add("recommendationDate", (Object)this._recommendationDate).toString();
    }
}

