/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.server.model.validation.validator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.container.server.i18n.DynamicAttributeErrorMessages;
import de.justsoftware.onx.container.server.model.validation.EntityDynamicAttributeValidationModel;
import de.justsoftware.onx.container.server.model.validation.constraint.ValidEntityWithAttributesConstraint;
import de.justsoftware.onx.container.server.model.validation.validator.AbstractServerValidator;
import de.justsoftware.onx.container.server.model.validation.validator.EntityDynamicAttributeValidator;
import de.justsoftware.onx.container.shared.server.model.EntityWithDynamicAttributes;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityMandatoryAttributesValidator
extends AbstractServerValidator
implements ConstraintValidator<ValidEntityWithAttributesConstraint, EntityWithDynamicAttributes> {
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private I18nService _i18nService;

    public void initialize(ValidEntityWithAttributesConstraint arg0) {
    }

    public boolean isValid(EntityWithDynamicAttributes entity, ConstraintValidatorContext context) {
        ImmutableList<DynamicAttributeConfig> configList = this._entityConfigService.getDynamicAttributesForType(entity.getType());
        if (configList.isEmpty() && !entity.getDynamicAttributes().isEmpty()) {
            return false;
        }
        boolean isValid = true;
        String language = this.getLanguage();
        DynamicAttributeErrorMessages errorMessages = this._i18nService.createProxy(DynamicAttributeErrorMessages.class, language);
        ImmutableMap attributeMap = Maps.uniqueIndex(entity.getDynamicAttributes(), EntityDynamicAttributeValidationModel.TO_ATTRIBUTE_ID);
        for (DynamicAttributeConfig config : configList) {
            if (!config.isMandatory() || attributeMap.containsKey((Object)config.getId())) continue;
            DynamicEntityAttributesMessages attributeMessages = this._i18nService.getEntityAttributeMessages(entity.getType(), config.getId(), language);
            EntityDynamicAttributeValidator.addErrorMessageToContext(errorMessages.attributeRequired(attributeMessages.name(config.getId())), config.getId(), context);
            isValid = false;
        }
        if (!isValid) {
            context.disableDefaultConstraintViolation();
        }
        return isValid;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityConfigService", (Object)this._entityConfigService).add("i18nService", (Object)this._i18nService).toString();
    }
}

