/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.server.model.validation.validator;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.AbstractTextInput;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.server.i18n.DynamicAttributeErrorMessages;
import de.justsoftware.onx.container.server.model.validation.EntityDynamicAttributeValidationModel;
import de.justsoftware.onx.container.server.model.validation.constraint.EntityDynamicAttributeConstraint;
import de.justsoftware.onx.container.server.model.validation.validator.AbstractServerValidator;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.math.NumberRange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityDynamicAttributeValidator
extends AbstractServerValidator
implements ConstraintValidator<EntityDynamicAttributeConstraint, EntityDynamicAttributeValidationModel> {
    private static final String VALUE = "VALUE";
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;

    public void initialize(EntityDynamicAttributeConstraint constraint) {
    }

    public boolean isValid(EntityDynamicAttributeValidationModel attribute, ConstraintValidatorContext context) {
        boolean isValid;
        ImmutableList<DynamicAttributeConfig> configList = this._entityConfigService.getDynamicAttributesForType(attribute.getType());
        DynamicAttributeId attributeId = attribute.getAttributeId();
        DynamicAttributeConfig config = (DynamicAttributeConfig)Iterables.find(configList, Identifiables.idEquals(attributeId), null);
        String language = this.getLanguage();
        DynamicAttributeErrorMessages errorMessages = this._i18nService.createProxy(DynamicAttributeErrorMessages.class, language);
        DynamicEntityAttributesMessages attributeMessages = this._i18nService.getEntityAttributeMessages(attribute.getType(), attributeId, language);
        if (config == null) {
            EntityDynamicAttributeValidator.addErrorMessageToContext(errorMessages.attributeNotConfigured(attributeMessages.name(attributeId)), attribute.getAttributeId(), context);
            return false;
        }
        boolean numbersValid = this.validateNumberOfValues(attribute, context, attributeId, errorMessages, attributeMessages, config);
        boolean inputValid = config.getInput().accept(new InputValidationVisitor(attribute, errorMessages, context));
        boolean bl = isValid = numbersValid && inputValid;
        if (!isValid) {
            context.disableDefaultConstraintViolation();
        }
        return isValid;
    }

    private boolean validateNumberOfValues(@Nonnull EntityDynamicAttributeValidationModel attribute, @Nonnull ConstraintValidatorContext context, @Nonnull DynamicAttributeId attributeId, @Nonnull DynamicAttributeErrorMessages errorMessages, @Nonnull DynamicEntityAttributesMessages attributeMessages, @Nonnull DynamicAttributeConfig config) {
        long min;
        Range range = config.getMultiplicity();
        if (!range.hasRestrictions()) {
            return true;
        }
        int numberOfValues = attribute.getValues().size();
        if ((long)numberOfValues < (min = range.getMin().longValue())) {
            if (min > 1L) {
                context.buildConstraintViolationWithTemplate(errorMessages.notEnoughValuesForAttribute(Numbers.longValue(range.getMin()))).addNode(attributeId.getId()).addNode(VALUE).inIterable().atIndex(Integer.valueOf(numberOfValues)).addConstraintViolation();
            } else {
                EntityDynamicAttributeValidator.addErrorMessageToContext(errorMessages.attributeRequired(attributeMessages.name(attributeId)), attribute.getAttributeId(), context);
            }
            return false;
        }
        if ((long)numberOfValues > Numbers.longValue(range.getMax(), numberOfValues)) {
            context.buildConstraintViolationWithTemplate(errorMessages.tooManyValuesForAttribute(Numbers.longValue(range.getMax()))).addNode(attributeId.getId()).addConstraintViolation();
            return false;
        }
        return true;
    }

    protected static void addErrorMessageToContext(@Nonnull String errorMessage, @Nonnull DynamicAttributeId attributeId, @Nonnull ConstraintValidatorContext context) {
        EntityDynamicAttributeValidator.addErrorMessageToContextForValueNumber(errorMessage, attributeId, context, 0);
    }

    private static void addErrorMessageToContextForValueNumber(@Nonnull String errorMessage, @Nonnull DynamicAttributeId attributeId, @Nonnull ConstraintValidatorContext context, @Nonnull Integer valueIndex) {
        context.buildConstraintViolationWithTemplate(errorMessage).addNode(attributeId.getId()).addNode(VALUE).inIterable().atIndex(valueIndex).addConstraintViolation();
    }

    public String toString() {
        return "EntityDynamicAttributeValidator";
    }

    private final class InputValidationVisitor
    implements Input.InputVisitor<Boolean> {
        private final EntityDynamicAttributeValidationModel _attribute;
        private final DynamicAttributeErrorMessages _errorMessages;
        private final ConstraintValidatorContext _context;

        private InputValidationVisitor(@Nonnull EntityDynamicAttributeValidationModel attribute, @Nonnull DynamicAttributeErrorMessages errorMessages, ConstraintValidatorContext context) {
            this._attribute = attribute;
            this._errorMessages = errorMessages;
            this._context = context;
        }

        @Override
        public Boolean visit(TextAreaInput input) {
            return this.validateTextValue(input);
        }

        @Override
        public Boolean visit(TextInput input) {
            return this.validateTextValue(input);
        }

        @Nonnull
        private Boolean validateTextValue(@Nonnull AbstractTextInput input) {
            Range range = input.getRange();
            if (!range.hasRestrictions()) {
                return Boolean.TRUE;
            }
            Boolean result = Boolean.TRUE;
            long minimum = range.getMin();
            long maximum = Numbers.longValue(range.getMax(), Long.MAX_VALUE);
            int i = 0;
            for (String value : this._attribute.getValues()) {
                int valueLength = value.length();
                if ((long)valueLength < minimum || (long)valueLength > maximum) {
                    EntityDynamicAttributeValidator.addErrorMessageToContextForValueNumber(this._errorMessages.attributeValueOutOfRange(valueLength, minimum, maximum), this._attribute.getAttributeId(), this._context, i);
                    result = Boolean.FALSE;
                }
                ++i;
            }
            return result;
        }

        @Override
        public Boolean visit(SelectionInput input) {
            Boolean valid = Boolean.TRUE;
            HashSet valueSet = Sets.newHashSet();
            int i = 0;
            for (String value : this._attribute.getValues()) {
                if (!valueSet.add(value)) {
                    this._context.buildConstraintViolationWithTemplate(this._errorMessages.nonUniqueSelection()).addNode(this._attribute.getAttributeId().getId()).addNode(EntityDynamicAttributeValidator.VALUE).inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                    valid = Boolean.FALSE;
                }
                ++i;
            }
            return valid;
        }

        @Override
        public Boolean visit(PersonSuggestInput suggestInput) {
            Boolean valid = Boolean.TRUE;
            HashSet valueSet = Sets.newHashSet();
            int i = 0;
            ImmutableSet values = FluentIterable.from(this._attribute.getValues()).transform(PersonId.PARSE).toSet();
            ImmutableMap<PersonId, DBPerson> persons = EntityDynamicAttributeValidator.this._personService.getPersonsByIds((Set<PersonId>)values);
            for (PersonId personId : values) {
                if (!valueSet.add(personId)) {
                    this._context.buildConstraintViolationWithTemplate(this._errorMessages.nonUniquePersonSelection()).addNode(this._attribute.getAttributeId().getId()).addNode(EntityDynamicAttributeValidator.VALUE).inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                    valid = Boolean.FALSE;
                }
                if (!persons.containsKey(personId)) {
                    this._context.buildConstraintViolationWithTemplate(this._errorMessages.personDoesNotExist()).addNode(this._attribute.getAttributeId().getId()).addNode(EntityDynamicAttributeValidator.VALUE).inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                    valid = Boolean.FALSE;
                }
                ++i;
            }
            return valid;
        }

        @Override
        public Boolean visit(NumberInput numberInput) {
            Boolean valid = Boolean.TRUE;
            int i = 0;
            for (String value : this._attribute.getValues()) {
                BigDecimal numberValue = null;
                try {
                    numberValue = Numbers.toBigDecimal(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (numberValue == null) {
                    EntityDynamicAttributeValidator.addErrorMessageToContextForValueNumber(this._errorMessages.notANumer(value), this._attribute.getAttributeId(), this._context, i);
                    valid = Boolean.FALSE;
                } else {
                    NumberRange range = new NumberRange((Number)numberInput.getMin(), (Number)numberInput.getMax());
                    if (!range.containsNumber((Number)numberValue)) {
                        EntityDynamicAttributeValidator.addErrorMessageToContextForValueNumber(this._errorMessages.numberValueOutOfRange(numberInput.getMin().toString(), numberInput.getMax().toString()), this._attribute.getAttributeId(), this._context, i);
                        valid = Boolean.FALSE;
                    }
                    if (!numberInput.numberOfDecimalsValid(numberValue)) {
                        EntityDynamicAttributeValidator.addErrorMessageToContextForValueNumber(this._errorMessages.numberTooManyDecimals(numberInput.getDecimals()), this._attribute.getAttributeId(), this._context, i);
                        valid = Boolean.FALSE;
                    }
                }
                ++i;
            }
            return valid;
        }

        @Override
        public Boolean visit(ArithmeticOperationInput input) {
            return Boolean.TRUE;
        }
    }
}

